package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewWelcomeVideoBinding
import ai.engagely.openbot.model.pojos.internal.botsettings.IPlayerSize
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.FrameLayout
import android.widget.ImageButton
import com.google.android.exoplayer2.Player

class WelcomeVideoView : FrameLayout {

    private var binding: ViewWelcomeVideoBinding? = null
    private var onPlayClickListener: OnPlayClickListener? = null
    private var ibFullScreen: ImageButton? = null
    private var ibVolumeHigh: ImageButton? = null
    private var ibVolumeOff: ImageButton? = null
    private var playbackSpeedMenu: PlaybackSpeedMenu? = null
    private var playerMoreMenuView: PlayerMoreMenuView? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewWelcomeVideoBinding.inflate(LayoutInflater.from(context), this, true)
        ibFullScreen = binding?.playerView?.findViewById(R.id.ib_full_screen)
        ibVolumeHigh = binding?.playerView?.findViewById(R.id.ib_volume_high)
        ibVolumeOff = binding?.playerView?.findViewById(R.id.ib_volume_off)
        playbackSpeedMenu =
            binding?.playerView?.findViewById(R.id.playbackSpeedMenu)
        playerMoreMenuView =
            binding?.playerView?.findViewById(R.id.playerMoreMenu)
    }

    fun setData(onPlayClickListener: OnPlayClickListener?) {
        this.onPlayClickListener = onPlayClickListener
        ibFullScreen?.setOnClickListener {
            this.onPlayClickListener?.onFullScreenClicked()
        }

        ibVolumeHigh?.setOnClickListener {
            this.onPlayClickListener?.onVolumeToggleClicked()
        }
        ibVolumeOff?.setOnClickListener {
            this.onPlayClickListener?.onVolumeToggleClicked()
        }
        playerMoreMenuView?.setData(object : PlayerMoreMenuView.PlayerMoreMenuClickListener {
            override fun onDownloadMenuSelected() {
                onPlayClickListener?.onDownloadMenuSelected()
            }

            override fun onPictureInPictureSelected() {
                onPlayClickListener?.onPictureInPictureSelected()
            }
        })
    }

    fun setPlayer(player: Player?) {
        binding?.playerView?.player = player
    }

    fun setVolumeMuted(muted: Boolean?) {
        val showMuted = muted == true
        ibVolumeOff?.visibility = if (showMuted) View.VISIBLE else View.GONE
        ibVolumeHigh?.visibility = if (showMuted) View.GONE else View.VISIBLE
    }

    fun setPlaybackSpeed(speed: Float) {
        playbackSpeedMenu?.setData(speed, object : PlaybackSpeedMenu.PlaybackSpeedListener {
            override fun onPlaybackSpeedChanged(speed: Float) {
                onPlayClickListener?.onPlaybackSpeedChanged(speed)
            }
        })
    }

    fun setPlayerPIPMode(inPIPMode: Boolean?) {
        val hidePlayer = inPIPMode == true
        binding?.tvPIPInfo?.visibility = if (hidePlayer) VISIBLE else INVISIBLE
        binding?.videoContainer?.visibility = if (hidePlayer) INVISIBLE else VISIBLE
    }

    fun getPlayerSize(): IPlayerSize {
        return IPlayerSize(
            width = binding?.playerView?.width ?: 0,
            height = binding?.playerView?.height ?: 0
        )
    }

    interface OnPlayClickListener {
        fun onPlayClicked(url: String?)
        fun onFullScreenClicked()
        fun onVolumeToggleClicked()
        fun onPlaybackSpeedChanged(speed: Float)
        fun onDownloadMenuSelected()
        fun onPictureInPictureSelected()
    }
}