/*
 * Decompiled with CFR 0.152.
 */
package ai.eto.rikai.sql.model;

import ai.eto.rikai.sql.model.Model;
import ai.eto.rikai.sql.model.ModelNotFoundException;
import ai.eto.rikai.sql.model.ModelRegistryAlreadyExistException;
import ai.eto.rikai.sql.model.ModelResolveException;
import ai.eto.rikai.sql.model.ModelSpec;
import ai.eto.rikai.sql.model.Registry;
import java.io.Serializable;
import java.net.URI;
import org.apache.http.client.utils.URIUtils;
import org.apache.log4j.Logger;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Registry$ {
    public static Registry$ MODULE$;
    private final String REGISTRY_IMPL_PREFIX;
    private final String REGISTRY_IMPL_SUFFIX;
    private final String DEFAULT_URI_ROOT_KEY;
    private final Map<String, String> DEFAULT_REGISTRIES;
    private final Logger logger;
    private Map<String, Registry> registryMap;
    private URI defaultUriRoot;

    static {
        new Registry$();
    }

    public String REGISTRY_IMPL_PREFIX() {
        return this.REGISTRY_IMPL_PREFIX;
    }

    public String REGISTRY_IMPL_SUFFIX() {
        return this.REGISTRY_IMPL_SUFFIX;
    }

    public String DEFAULT_URI_ROOT_KEY() {
        return this.DEFAULT_URI_ROOT_KEY;
    }

    public Map<String, String> DEFAULT_REGISTRIES() {
        return this.DEFAULT_REGISTRIES;
    }

    private Logger logger() {
        return this.logger;
    }

    private Map<String, Registry> registryMap() {
        return this.registryMap;
    }

    private void registryMap_$eq(Map<String, Registry> x$1) {
        this.registryMap = x$1;
    }

    private URI defaultUriRoot() {
        return this.defaultUriRoot;
    }

    private void defaultUriRoot_$eq(URI x$1) {
        this.defaultUriRoot = x$1;
    }

    public void registerAll(Map<String, String> conf) {
        this.DEFAULT_REGISTRIES().$plus$plus(conf).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Registry$.$anonfun$registerAll$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            Registry$.$anonfun$registerAll$2(conf, x$1);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyScheme(String scheme) throws ModelResolveException {
        String schemeRegex = "[a-zA-Z][\\w\\+]{0,255}";
        if (scheme != null && !scheme.matches(schemeRegex)) {
            throw new ModelResolveException(new StringBuilder(27).append("Scheme '").append(scheme).append("' does not match '").append(schemeRegex).append("'").toString());
        }
    }

    public Registry getRegistry(String uri) throws ModelResolveException {
        Registry registry;
        URI parsedNormalizedUri = this.normalize_uri(uri);
        String scheme = parsedNormalizedUri.getScheme();
        Option option = this.registryMap().get((Object)scheme);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new ModelResolveException(new StringBuilder(41).append("Model registry scheme '").append(scheme).append("' is not supported").toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Registry registry2 = registry = (Registry)some.value();
        return registry2;
    }

    public URI normalize_uri(String uri) {
        String string;
        URI parsedUri = new URI(uri);
        String string2 = parsedUri.getScheme();
        URI uRI = string2 != null && !(string = string2).isEmpty() ? parsedUri : URIUtils.resolve((URI)this.defaultUriRoot(), (String)uri);
        return uRI;
    }

    public Model resolve(SparkSession session, ModelSpec spec) throws ModelResolveException, ModelNotFoundException {
        return this.getRegistry(spec.uri()).resolve(session, spec);
    }

    public void reset() {
        this.registryMap_$eq((Map<String, Registry>)Predef$.MODULE$.Map().empty());
    }

    public static final /* synthetic */ boolean $anonfun$registerAll$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$registerAll$2(Map conf$1, Tuple2 x$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            String string = key;
            String string2 = MODULE$.DEFAULT_URI_ROOT_KEY();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Success success;
                URI uri;
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new URI(value));
                if (!(try_ instanceof Success) || (uri = (URI)(success = (Success)try_).value()).getScheme() == null || !new StringOps(Predef$.MODULE$.augmentString(uri.getScheme())).nonEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(65).append("Default URI root ").append(value).append(" is not well-formed or does not specify a scheme").toString());
                }
                MODULE$.defaultUriRoot_$eq(uri);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else if (key.startsWith(MODULE$.REGISTRY_IMPL_PREFIX()) && key.endsWith(MODULE$.REGISTRY_IMPL_SUFFIX())) {
                String scheme = key.substring(MODULE$.REGISTRY_IMPL_PREFIX().length(), key.length() - MODULE$.REGISTRY_IMPL_SUFFIX().length());
                MODULE$.verifyScheme(scheme);
                if (MODULE$.registryMap().contains((Object)scheme)) {
                    throw new ModelRegistryAlreadyExistException(scheme != null ? new StringBuilder(22).append("ModelRegistry(").append(scheme).append(") exists").toString() : "Default ModelRegistry exists");
                }
                MODULE$.registryMap_$eq((Map<String, Registry>)MODULE$.registryMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scheme), (Object)((Registry)Class.forName(value).getDeclaredConstructor(Map.class).newInstance(conf$1)))));
                MODULE$.logger().debug((Object)new StringBuilder(31).append("Model Registry ").append(scheme).append(" registered to: ").append(value).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit3 = boxedUnit;
    }

    private Registry$() {
        MODULE$ = this;
        this.REGISTRY_IMPL_PREFIX = "spark.rikai.sql.ml.registry.";
        this.REGISTRY_IMPL_SUFFIX = ".impl";
        this.DEFAULT_URI_ROOT_KEY = "spark.rikai.sql.ml.registry.uri.root";
        this.DEFAULT_REGISTRIES = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.rikai.sql.ml.registry.file.impl"), (Object)"ai.eto.rikai.sql.model.fs.FileSystemRegistry"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.rikai.sql.ml.registry.mlflow.impl"), (Object)"ai.eto.rikai.sql.model.mlflow.MlflowRegistry")}));
        this.logger = Logger.getLogger(this.getClass());
        this.registryMap = Predef$.MODULE$.Map().empty();
        this.defaultUriRoot = new URI("file:/");
    }
}

