/*
 * Decompiled with CFR 0.152.
 */
package ai.expert.nlapi.security;

import ai.expert.nlapi.security.Credential;
import ai.expert.nlapi.security.CredentialsProvider;
import ai.expert.nlapi.utils.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnvironmentVariablesCredentialsProvider
extends CredentialsProvider {
    private static final Logger logger = LogManager.getLogger();

    @Override
    public Credential getCredentials() {
        logger.debug("Getting Credentials from Environment Variables...");
        String username = StringUtils.trim(System.getenv("EAI_USERNAME"));
        String password = StringUtils.trim(System.getenv("EAI_PASSWORD"));
        String token = StringUtils.trim(System.getenv("EAI_TOKEN"));
        if (token == null || token.isEmpty()) {
            if (username == null || username.isEmpty()) {
                return null;
            }
            if (password == null || password.isEmpty()) {
                return null;
            }
            logger.info("Found Credentials from Environment Variables.");
        } else {
            logger.info("Found Token from Environment Variables.");
        }
        return new Credential(username, password, token);
    }
}

