/*
 * Decompiled with CFR 0.152.
 */
package ai.expert.nlapi.security;

import ai.expert.nlapi.security.Credential;
import ai.expert.nlapi.security.CredentialsProvider;
import ai.expert.nlapi.utils.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SystemPropertyCredentialsProvider
extends CredentialsProvider {
    private static final Logger logger = LogManager.getLogger();

    @Override
    public Credential getCredentials() {
        logger.debug("Getting Credentials from System Property...");
        String username = StringUtils.trim(System.getProperty("eai.username"));
        String password = StringUtils.trim(System.getProperty("eai.password"));
        String token = StringUtils.trim(System.getProperty("eai.token"));
        if (token == null || token.isEmpty()) {
            if (username == null || username.isEmpty()) {
                return null;
            }
            if (password == null || password.isEmpty()) {
                return null;
            }
            logger.info("Found Credentials from System Property.");
        } else {
            logger.info("Found Token from System Property.");
        }
        return new Credential(username, password, token);
    }
}

