/*
 * Decompiled with CFR 0.152.
 */
package ai.expert.nlapi.utils;

import ai.expert.nlapi.exceptions.NLApiErrorCode;
import ai.expert.nlapi.exceptions.NLApiException;
import ai.expert.nlapi.security.Authentication;
import ai.expert.nlapi.security.SecurityUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class APIUtils {
    private static final Logger logger = LogManager.getLogger();

    public static <T> T fromJSON(String json, Class<T> valueType) throws NLApiException {
        Object response;
        try {
            ObjectMapper om = new ObjectMapper();
            om.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
            response = om.readValue(json, valueType);
        }
        catch (JsonMappingException e) {
            String msg = String.format("Please report this issue. Error while parsing json response into class [%s]: %s", valueType.toString(), json);
            logger.error(msg);
            logger.error((Object)e);
            throw new NLApiException(NLApiErrorCode.PARSING_ERROR, msg);
        }
        catch (JsonProcessingException e) {
            String msg = String.format("Please report this issue. Error while processing json into class [%s]: %s", valueType.toString(), json);
            logger.error(msg);
            logger.error((Object)e);
            throw new NLApiException(NLApiErrorCode.PARSING_ERROR, msg);
        }
        return (T)response;
    }

    public static String getBearerToken(Authentication authentication) throws NLApiException {
        return SecurityUtils.bearerOf(authentication.isValid() ? authentication.getJWT() : authentication.refresh());
    }
}

