/*
 * Decompiled with CFR 0.152.
 */
package ai.expert.nlapi.security;

import ai.expert.nlapi.exceptions.NLApiErrorCode;
import ai.expert.nlapi.exceptions.NLApiException;
import ai.expert.nlapi.security.Authenticator;
import ai.expert.nlapi.security.Credential;
import ai.expert.nlapi.security.CredentialsProvider;
import ai.expert.nlapi.utils.ObjectMapperAdapter;
import ai.expert.nlapi.utils.StringUtils;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.ObjectMapper;
import kong.unirest.Unirest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasicAuthenticator
implements Authenticator {
    private static final Logger logger = LogManager.getLogger();
    private final Credential credential;

    public BasicAuthenticator(Credential credential) {
        this.credential = credential;
        this.init();
    }

    public BasicAuthenticator(CredentialsProvider credentialProvider) {
        this.credential = credentialProvider.getCredentials();
        this.init();
    }

    private void init() {
        Unirest.config().setObjectMapper((ObjectMapper)new ObjectMapperAdapter());
    }

    @Override
    public String authenticate() throws NLApiException {
        if (this.credential == null) {
            String msg = "Please check credential settings.";
            logger.error(msg);
            throw new NLApiException(NLApiErrorCode.AUTHENTICATION_ERROR, msg);
        }
        if (!StringUtils.isBlank(this.credential.getToken())) {
            return this.credential.getToken();
        }
        if (this.credential.getUsername() == null || this.credential.getUsername().isEmpty()) {
            String msg = "Please check settings credential username.";
            logger.error(msg);
            throw new NLApiException(NLApiErrorCode.AUTHENTICATION_ERROR, msg);
        }
        if (this.credential.getPassword() == null || this.credential.getPassword().isEmpty()) {
            String msg = "Please check settings credential password.";
            logger.error(msg);
            throw new NLApiException(NLApiErrorCode.AUTHENTICATION_ERROR, msg);
        }
        HttpResponse httpResponse = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)"https://developer.expert.ai/oauth2/token").header("Content-Type", "application/json")).header("Accept", "*/*")).body(this.getCredential().toJSON()).asString();
        if (httpResponse.getStatus() == 500) {
            String msg = String.format("Authentication call to API %s return error status %d with message %s", "https://developer.expert.ai/oauth2/token", httpResponse.getStatus(), httpResponse.getBody());
            logger.error(msg);
            throw new NLApiException(NLApiErrorCode.AUTHORIZATION_ERROR, msg);
        }
        if (httpResponse.getStatus() != 200) {
            String msg = String.format("Authentication call to API %s return error status %d", "https://developer.expert.ai/oauth2/token", httpResponse.getStatus());
            logger.error(msg);
            throw new NLApiException(NLApiErrorCode.AUTHORIZATION_ERROR, msg);
        }
        return (String)httpResponse.getBody();
    }

    public Credential getCredential() {
        return this.credential;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicAuthenticator)) {
            return false;
        }
        BasicAuthenticator other = (BasicAuthenticator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Credential this$credential = this.getCredential();
        Credential other$credential = other.getCredential();
        return !(this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasicAuthenticator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Credential $credential = this.getCredential();
        result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
        return result;
    }

    public String toString() {
        return "BasicAuthenticator(credential=" + this.getCredential() + ")";
    }
}

