/*
 * Decompiled with CFR 0.152.
 */
package ai.expert.nlapi.v2.cloud;

import ai.expert.nlapi.exceptions.NLApiErrorCode;
import ai.expert.nlapi.exceptions.NLApiException;
import ai.expert.nlapi.security.Authentication;
import ai.expert.nlapi.utils.APIUtils;
import ai.expert.nlapi.utils.ObjectMapperAdapter;
import ai.expert.nlapi.v2.cloud.AnalyzerConfig;
import ai.expert.nlapi.v2.message.AnalysisRequest;
import ai.expert.nlapi.v2.message.AnalyzeResponse;
import ai.expert.nlapi.v2.model.Document;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.ObjectMapper;
import kong.unirest.Unirest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Analyzer {
    private static final Logger logger = LogManager.getLogger();
    private final Authentication authentication;
    private final String URL;

    public Analyzer(AnalyzerConfig config) {
        this.authentication = config.getAuthentication();
        this.URL = String.format("%s/%s/analyze/%s/%s", new Object[]{"https://nlapi.expert.ai", config.getVersion(), config.getContext().toLowerCase(), config.getLanguage().code()});
        Unirest.config().addDefaultHeader("Content-Type", "application/json").addDefaultHeader("Accept", "application/json").setObjectMapper((ObjectMapper)new ObjectMapperAdapter());
    }

    public AnalyzeResponse analyze(String text, String analysisType) throws NLApiException {
        return this.getResponseDocument(text, analysisType);
    }

    public AnalyzeResponse analyze(String text) throws NLApiException {
        return this.getResponseDocument(text, null);
    }

    public AnalyzeResponse disambiguation(String text) throws NLApiException {
        return this.getResponseDocument(text, "disambiguation");
    }

    public AnalyzeResponse relevants(String text) throws NLApiException {
        return this.getResponseDocument(text, "relevants");
    }

    public AnalyzeResponse entities(String text) throws NLApiException {
        return this.getResponseDocument(text, "entities");
    }

    public AnalyzeResponse relations(String text) throws NLApiException {
        return this.getResponseDocument(text, "relations");
    }

    public AnalyzeResponse sentiment(String text) throws NLApiException {
        return this.getResponseDocument(text, "sentiment");
    }

    private AnalyzeResponse getResponseDocument(String text, String analysisType) throws NLApiException {
        String json = this.getResponseDocumentString(text, analysisType);
        AnalyzeResponse response = APIUtils.fromJSON(json, AnalyzeResponse.class);
        if (response.isSuccess()) {
            return response;
        }
        String msg = String.format("Analyze call to API %s return an error json: %s", this.URL, json);
        logger.error(msg);
        throw new NLApiException(NLApiErrorCode.EXECUTION_REQUEST_ERROR, msg);
    }

    public String getResponseDocumentString(String text, String analysisType) throws NLApiException {
        String URLpath = this.URL;
        if (analysisType != null && !analysisType.isEmpty() && !analysisType.equalsIgnoreCase("full")) {
            URLpath = this.URL + "/" + analysisType.toLowerCase();
        }
        logger.debug("Sending text to analyze API: " + URLpath);
        HttpResponse response = ((HttpRequestWithBody)Unirest.post((String)URLpath).header("Authorization", APIUtils.getBearerToken(this.authentication))).body(new AnalysisRequest(Document.of(text)).toJSON()).asString();
        if (response.getStatus() != 200) {
            String msg = String.format("Analyze call to API %s return error status %d", URLpath, response.getStatus());
            logger.error(msg);
            throw new NLApiException(NLApiErrorCode.CONNECTION_ERROR, msg);
        }
        String type = analysisType != null && !analysisType.isEmpty() ? analysisType : "full";
        logger.info(String.format("Analyze %s call successful", type));
        return (String)response.getBody();
    }
}

