/*
 * Decompiled with CFR 0.152.
 */
package ai.expert.nlapi.v2.cloud;

import ai.expert.nlapi.exceptions.NLApiErrorCode;
import ai.expert.nlapi.exceptions.NLApiException;
import ai.expert.nlapi.security.Authentication;
import ai.expert.nlapi.utils.APIUtils;
import ai.expert.nlapi.utils.ObjectMapperAdapter;
import ai.expert.nlapi.v2.cloud.DetectorConfig;
import ai.expert.nlapi.v2.message.AnalysisRequest;
import ai.expert.nlapi.v2.message.DetectResponse;
import ai.expert.nlapi.v2.model.Document;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.ObjectMapper;
import kong.unirest.Unirest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Detector {
    private static final Logger logger = LogManager.getLogger();
    private final Authentication authentication;
    private final String URL;

    public Detector(DetectorConfig config) {
        this.authentication = config.getAuthentication();
        this.URL = String.format("%s/%s/detect/%s/%s", new Object[]{"https://nlapi.expert.ai", config.getVersion(), config.getDetector().toLowerCase(), config.getLanguage().code()});
        Unirest.config().addDefaultHeader("Content-Type", "application/json").addDefaultHeader("Accept", "application/json").setObjectMapper((ObjectMapper)new ObjectMapperAdapter());
    }

    public DetectResponse detect(String text) throws NLApiException {
        String json = this.detectionAsString(text);
        DetectResponse response = APIUtils.fromJSON(json, DetectResponse.class);
        if (response.isSuccess()) {
            return response;
        }
        String msg = String.format("Detection call to API %s return an error json: %s", this.URL, json);
        logger.error(msg);
        throw new NLApiException(NLApiErrorCode.EXECUTION_REQUEST_ERROR, msg);
    }

    public String detectionAsString(String text) throws NLApiException {
        logger.debug("Sending text to detect API: " + this.URL);
        HttpResponse response = ((HttpRequestWithBody)Unirest.post((String)this.URL).header("Authorization", APIUtils.getBearerToken(this.authentication))).body(new AnalysisRequest(Document.of(text)).toJSON()).asString();
        if (response.getStatus() != 200) {
            String msg = String.format("Detection call to API %s return error status %d", this.URL, response.getStatus());
            logger.error(msg);
            throw new NLApiException(NLApiErrorCode.CONNECTION_ERROR, msg);
        }
        logger.info("Detection call successful");
        return (String)response.getBody();
    }
}

