/*
 * Decompiled with CFR 0.152.
 */
package ai.expert.nlapi.v2.edge;

import ai.expert.nlapi.exceptions.NLApiErrorCode;
import ai.expert.nlapi.exceptions.NLApiException;
import ai.expert.nlapi.utils.APIUtils;
import ai.expert.nlapi.utils.ObjectMapperAdapter;
import ai.expert.nlapi.v2.edge.ModelConfig;
import ai.expert.nlapi.v2.message.ModelRequest;
import ai.expert.nlapi.v2.message.TaxonomyModelResponse;
import ai.expert.nlapi.v2.message.TemplatesModelResponse;
import kong.unirest.HttpResponse;
import kong.unirest.ObjectMapper;
import kong.unirest.Unirest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Model {
    private static final Logger logger = LogManager.getLogger();
    private final String resource;
    private final String EDGE_URL;

    public Model(ModelConfig config) {
        this.resource = config.getResource();
        this.EDGE_URL = String.format("%s/api/model", config.getHost());
        Unirest.config().addDefaultHeader("Content-Type", "application/json").addDefaultHeader("Accept", "application/json").setObjectMapper((ObjectMapper)new ObjectMapperAdapter());
    }

    public TaxonomyModelResponse taxonomy() throws NLApiException {
        return this.getTaxonomyModelResponse();
    }

    public TemplatesModelResponse templates() throws NLApiException {
        return this.getTemplatesModelResponse();
    }

    private TaxonomyModelResponse getTaxonomyModelResponse() throws NLApiException {
        String json = this.getModelResponseString("taxonomy");
        TaxonomyModelResponse response = APIUtils.fromJSON(json, TaxonomyModelResponse.class);
        if (response.isSuccess()) {
            return response;
        }
        String msg = String.format("Edge taxonomy model call return an error json: %s", json);
        logger.error(msg);
        throw new NLApiException(NLApiErrorCode.EXECUTION_REQUEST_ERROR, msg);
    }

    private TemplatesModelResponse getTemplatesModelResponse() throws NLApiException {
        String json = this.getModelResponseString("templates");
        TemplatesModelResponse response = APIUtils.fromJSON(json, TemplatesModelResponse.class);
        if (response.isSuccess()) {
            return response;
        }
        String msg = String.format("Edge templates model call return an error json: %s", json);
        logger.error(msg);
        throw new NLApiException(NLApiErrorCode.EXECUTION_REQUEST_ERROR, msg);
    }

    private String getModelResponseString(String model) throws NLApiException {
        String URLpath = this.EDGE_URL;
        ModelRequest mr = new ModelRequest();
        mr.setInfo(model);
        mr.setResource(this.resource);
        logger.debug("Sending request to Edge Model API: " + URLpath);
        HttpResponse response = Unirest.post((String)URLpath).body(mr.toJSON()).asString();
        if (response.getStatus() != 200) {
            String msg = String.format("Edge Model call to API %s return error status %d", URLpath, response.getStatus());
            logger.error(msg);
            throw new NLApiException(NLApiErrorCode.CONNECTION_ERROR, msg);
        }
        logger.info("Edge Model call successful");
        return (String)response.getBody();
    }
}

