/*
 * Decompiled with CFR 0.152.
 */
package ai.expert.nlapi.v2.cloud;

import ai.expert.nlapi.exceptions.NLApiErrorCode;
import ai.expert.nlapi.exceptions.NLApiException;
import ai.expert.nlapi.security.Authentication;
import ai.expert.nlapi.utils.APIUtils;
import ai.expert.nlapi.utils.ObjectMapperAdapter;
import ai.expert.nlapi.v2.API;
import ai.expert.nlapi.v2.cloud.InfoAPIConfig;
import ai.expert.nlapi.v2.message.ContextsResponse;
import ai.expert.nlapi.v2.message.DetectorsResponse;
import ai.expert.nlapi.v2.message.TaxonomiesResponse;
import ai.expert.nlapi.v2.message.TaxonomyResponse;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.ObjectMapper;
import kong.unirest.Unirest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoAPI {
    private static final Logger logger = LoggerFactory.getLogger(InfoAPI.class);
    private final Authentication authentication;
    private final String URL;

    public InfoAPI(InfoAPIConfig config) {
        this.authentication = config.getAuthentication();
        this.URL = String.format("%s/%s", new Object[]{"https://nlapi.expert.ai", config.getVersion()});
        Unirest.config().addDefaultHeader("Content-Type", "application/json").addDefaultHeader("Accept", "application/json").setObjectMapper((ObjectMapper)new ObjectMapperAdapter());
    }

    public ContextsResponse getContexts() throws NLApiException {
        String URLGet = this.URL + "/contexts";
        logger.debug("Calling GET contexts: " + URLGet);
        HttpResponse response = ((GetRequest)Unirest.get((String)URLGet).header("Authorization", APIUtils.getBearerToken(this.authentication))).asString();
        if (response.getStatus() != 200) {
            String msg = String.format("GET contexts call to API %s return error status %d", URLGet, response.getStatus());
            logger.error(msg);
            throw new NLApiException(NLApiErrorCode.CONNECTION_ERROR, msg);
        }
        logger.info("GET contexts call successful");
        return APIUtils.fromJSON((String)response.getBody(), ContextsResponse.class);
    }

    public DetectorsResponse getDetectors() throws NLApiException {
        String URLGet = this.URL + "/detectors";
        logger.debug("Calling GET contexts: " + URLGet);
        HttpResponse response = ((GetRequest)Unirest.get((String)URLGet).header("Authorization", APIUtils.getBearerToken(this.authentication))).asString();
        if (response.getStatus() != 200) {
            String msg = String.format("GET contexts call to API %s return error status %d", URLGet, response.getStatus());
            logger.error(msg);
            throw new NLApiException(NLApiErrorCode.CONNECTION_ERROR, msg);
        }
        logger.info("GET contexts call successful");
        return APIUtils.fromJSON((String)response.getBody(), DetectorsResponse.class);
    }

    public TaxonomiesResponse getTaxonomies() throws NLApiException {
        String URLGet = this.URL + "/taxonomies";
        logger.debug("Calling GET taxonomies: " + URLGet);
        HttpResponse response = ((GetRequest)Unirest.get((String)URLGet).header("Authorization", APIUtils.getBearerToken(this.authentication))).asString();
        if (response.getStatus() != 200) {
            String msg = String.format("GET taxonomies call to API %s return error status %d", URLGet, response.getStatus());
            logger.error(msg);
            throw new NLApiException(NLApiErrorCode.CONNECTION_ERROR, msg);
        }
        logger.info("GET taxonomies call successful");
        return APIUtils.fromJSON((String)response.getBody(), TaxonomiesResponse.class);
    }

    public TaxonomyResponse getTaxonomy(String taxonomy, API.Languages lang) throws NLApiException {
        String URLGet = String.format("%s/taxonomies/%s/%s", this.URL, taxonomy.toLowerCase(), lang.code());
        logger.debug("Calling GET taxonomy: " + URLGet);
        HttpResponse response = ((GetRequest)Unirest.get((String)URLGet).header("Authorization", APIUtils.getBearerToken(this.authentication))).asString();
        if (response.getStatus() != 200) {
            String msg = String.format("GET taxonomy call to API %s return error status %d", URLGet, response.getStatus());
            logger.error(msg);
            throw new NLApiException(NLApiErrorCode.CONNECTION_ERROR, msg);
        }
        logger.info("GET taxonomy call successful");
        return APIUtils.fromJSON((String)response.getBody(), TaxonomyResponse.class);
    }
}

