/*
 * Decompiled with CFR 0.152.
 */
package ai.expert.nlapi.security;

import ai.expert.nlapi.exceptions.NLApiException;
import ai.expert.nlapi.security.Authenticator;
import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;

public class Authentication {
    private final Authenticator authenticator;
    private String JWT;

    public Authentication(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public boolean isValid() {
        return this.getJWT() != null && !this.getJWT().isEmpty() && !this.isExpired();
    }

    public boolean isExpired() {
        DecodedJWT decodedJWT = com.auth0.jwt.JWT.decode((String)this.getJWT());
        return decodedJWT.getExpiresAt().before(new Date());
    }

    public String getJWT() {
        return this.JWT;
    }

    public void setJWT(String JWT2) {
        this.JWT = JWT2;
    }

    public String refresh() throws NLApiException {
        this.JWT = this.authenticator.authenticate();
        return this.JWT;
    }
}

