/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.flavor;

import ai.freeplay.client.ProviderConfig;
import ai.freeplay.client.exceptions.FreeplayException;
import ai.freeplay.client.flavor.ChatFlavor;
import ai.freeplay.client.flavor.OpenAIFlavor;
import ai.freeplay.client.internal.HttpUtil;
import ai.freeplay.client.internal.JSONUtil;
import ai.freeplay.client.internal.TemplateUtils;
import ai.freeplay.client.model.ChatCompletionResponse;
import ai.freeplay.client.model.ChatMessage;
import ai.freeplay.client.model.CompletionResponse;
import ai.freeplay.client.model.IndexedChatMessage;
import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.net.http.HttpResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OpenAIChatFlavor
extends OpenAIFlavor
implements ChatFlavor {
    private static final String OPENAI_CHAT_URL = "https://api.openai.com/v1/chat/completions";

    @Override
    public Collection<ChatMessage> formatPrompt(String template, Map<String, Object> variables) {
        try {
            return JSON.std.listFrom((Object)template).stream().map(message -> {
                Map messageMap = (Map)message;
                String formatted = TemplateUtils.format(String.valueOf(messageMap.get("content")), variables);
                return new ChatMessage(String.valueOf(messageMap.get("role")), formatted);
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new FreeplayException("Error formatting chat prompt template.", e);
        }
    }

    @Override
    public CompletionResponse callService(Collection<ChatMessage> formattedMessages, ProviderConfig providerConfig, Map<String, Object> llmParameters) throws FreeplayException {
        ChatCompletionResponse chatResponse = this.callChatService(formattedMessages, providerConfig, llmParameters);
        return new CompletionResponse(chatResponse.getContent(), chatResponse.isComplete());
    }

    @Override
    public ChatCompletionResponse callChatService(Collection<ChatMessage> formattedMessages, ProviderConfig providerConfig, Map<String, Object> llmParameters) throws FreeplayException {
        HttpResponse<String> response;
        OpenAIChatFlavor.validateParameters(llmParameters);
        HashMap<String, Object> bodyMap = new HashMap<String, Object>(llmParameters);
        bodyMap.put("messages", formattedMessages);
        try {
            response = HttpUtil.postJsonWithBearer(OPENAI_CHAT_URL, bodyMap, providerConfig.getApiKey());
        }
        catch (Exception e) {
            throw new FreeplayException("Error calling OpenAI.", e);
        }
        Map<String, Object> responseBody = HttpUtil.parseBody(response);
        HttpUtil.throwIfError(response, 200);
        List choices = (List)responseBody.get("choices");
        OpenAIChatFlavor.validateChoices(choices);
        List<IndexedChatMessage> choiceMessages = choices.stream().map(messageObject -> {
            Map messageMap = (Map)messageObject.get("message");
            boolean isComplete = "stop".equals(messageObject.get("finish_reason"));
            return new IndexedChatMessage(String.valueOf(messageMap.get("role")), String.valueOf(messageMap.get("content")), (Integer)messageObject.get("index"), isComplete);
        }).collect(Collectors.toList());
        return new ChatCompletionResponse(choiceMessages);
    }

    @Override
    public String getFormatType() {
        return "openai_chat";
    }

    @Override
    public String serializeForRecord(Collection<ChatMessage> formattedMessages) {
        return JSONUtil.asString(formattedMessages);
    }

    private static void validateChoices(List<Map<String, Object>> choices) throws FreeplayException {
        if (choices.isEmpty()) {
            throw new FreeplayException("Did not get any 'choices' back from OpenAI.");
        }
    }
}

