/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.flavor;

import ai.freeplay.client.ProviderConfig;
import ai.freeplay.client.exceptions.FreeplayException;
import ai.freeplay.client.flavor.Flavor;
import ai.freeplay.client.flavor.OpenAIFlavor;
import ai.freeplay.client.internal.HttpUtil;
import ai.freeplay.client.internal.TemplateUtils;
import ai.freeplay.client.model.CompletionResponse;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpenAITextFlavor
extends OpenAIFlavor
implements Flavor<String> {
    private static final String OPENAI_COMPLETIONS_URL = "https://api.openai.com/v1/completions";

    @Override
    public String formatPrompt(String template, Map<String, Object> variables) {
        return TemplateUtils.format(template, variables);
    }

    @Override
    public CompletionResponse callService(String formattedPrompt, ProviderConfig providerConfig, Map<String, Object> llmParameters) throws FreeplayException {
        HttpResponse<String> response;
        OpenAITextFlavor.validateParameters(llmParameters);
        HashMap<String, Object> bodyMap = new HashMap<String, Object>(llmParameters);
        bodyMap.put("prompt", formattedPrompt);
        try {
            response = HttpUtil.postJsonWithBearer(OPENAI_COMPLETIONS_URL, bodyMap, providerConfig.getApiKey());
        }
        catch (Exception e) {
            throw new FreeplayException("Error calling OpenAI.", e);
        }
        Map<String, Object> responseBody = HttpUtil.parseBody(response);
        HttpUtil.throwIfError(response, 200);
        List choices = (List)responseBody.get("choices");
        OpenAITextFlavor.validateChoices(choices);
        Map choice = (Map)choices.get(0);
        boolean isComplete = "stop".equals(choice.get("finish_reason"));
        return new CompletionResponse(String.valueOf(choice.get("text")), isComplete);
    }

    @Override
    public String getFormatType() {
        return "openai_text";
    }

    @Override
    public String serializeForRecord(String formattedPrompt) {
        return formattedPrompt;
    }

    private static void validateChoices(List<Map<String, Object>> choices) throws FreeplayException {
        if (choices.isEmpty()) {
            throw new FreeplayException("Did not get any 'choices' back from OpenAI.");
        }
    }
}

