/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.model;

import ai.freeplay.client.exceptions.FreeplayException;
import ai.freeplay.client.flavor.ChatFlavor;
import ai.freeplay.client.internal.CallSupport;
import ai.freeplay.client.model.ChatCompletionResponse;
import ai.freeplay.client.model.ChatMessage;
import ai.freeplay.client.model.IndexedChatMessage;
import ai.freeplay.client.model.PromptTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ChatSession {
    private final CallSupport callSupport;
    private final String sessionId;
    private final PromptTemplate targetTemplate;
    private final List<ChatMessage> messageHistory = new ArrayList<ChatMessage>();
    private Map<String, Object> variables;
    private String tag;
    private String testRunId = null;

    public ChatSession(CallSupport callSupport, String sessionId, Collection<PromptTemplate> prompts, String templateName, String tag) throws FreeplayException {
        this.callSupport = callSupport;
        this.sessionId = sessionId;
        this.targetTemplate = callSupport.findPrompt(prompts, templateName).orElseThrow(() -> new FreeplayException("Cannot find template " + templateName + " in environment " + tag + "."));
    }

    public ChatSession startChat(Map<String, Object> variables, Map<String, Object> llmParameters, String environment, String testRunId, ChatFlavor flavor) {
        this.variables = variables;
        this.tag = environment;
        this.testRunId = testRunId;
        ChatFlavor activeFlavor = this.callSupport.getActiveChatFlavor(flavor, this.targetTemplate);
        Collection formattedMessages = (Collection)activeFlavor.formatPrompt(this.targetTemplate.getContent(), this.variables);
        this.continueChat(formattedMessages, llmParameters);
        return this;
    }

    public ChatCompletionResponse continueChat(ChatMessage newMessage) {
        return this.continueChat(List.of(newMessage), Collections.emptyMap());
    }

    public ChatCompletionResponse continueChat(ChatMessage newMessage, Map<String, Object> llmParameters) {
        return this.continueChat(List.of(newMessage), llmParameters);
    }

    public ChatCompletionResponse continueChat(Collection<ChatMessage> newMessages, Map<String, Object> llmParameters) {
        this.messageHistory.addAll(newMessages);
        List<ChatMessage> cleanMessages = this.toCleanMessages(this.messageHistory);
        ChatCompletionResponse response = this.callSupport.makeContinueChatCall(this.sessionId, this.targetTemplate, cleanMessages, this.variables, llmParameters, this.tag, this.testRunId);
        if (response.getFirstChoice().isPresent()) {
            this.messageHistory.add(response.getFirstChoice().get());
        }
        return response;
    }

    public List<ChatMessage> getMessageHistory() {
        return this.messageHistory;
    }

    public Optional<ChatMessage> getLastMessage() {
        if (this.messageHistory.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.messageHistory.get(this.messageHistory.size() - 1));
    }

    private List<ChatMessage> toCleanMessages(List<ChatMessage> messageHistory) {
        return messageHistory.stream().map(message -> message instanceof IndexedChatMessage ? new ChatMessage(message.getRole(), message.getContent()) : message).collect(Collectors.toList());
    }
}

