/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client;

import ai.freeplay.client.ProviderConfig;
import ai.freeplay.client.exceptions.FreeplayException;
import ai.freeplay.client.flavor.ChatFlavor;
import ai.freeplay.client.flavor.Flavor;
import ai.freeplay.client.internal.CallSupport;
import ai.freeplay.client.model.ChatSession;
import ai.freeplay.client.model.ChatStart;
import ai.freeplay.client.model.CompletionResponse;
import ai.freeplay.client.model.CompletionSession;
import ai.freeplay.client.model.IndexedChatMessage;
import ai.freeplay.client.model.PromptTemplate;
import ai.freeplay.client.model.TestRun;
import ai.freeplay.client.processor.PromptProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;

public class Freeplay {
    private final CallSupport callSupport;

    public Freeplay(String freeplayAPIKey, String baseUrl, ProviderConfig providerConfig) {
        this(freeplayAPIKey, baseUrl, providerConfig, null, null);
    }

    public Freeplay(String freeplayAPIKey, String baseUrl, ProviderConfig providerConfig, Map<String, Object> llmParameters) {
        this(freeplayAPIKey, baseUrl, providerConfig, null, llmParameters);
    }

    public Freeplay(String freeplayAPIKey, String baseUrl, ProviderConfig providerConfig, Flavor<?, ?> flavor, Map<String, Object> llmParameters) {
        this.callSupport = new CallSupport(freeplayAPIKey, baseUrl, providerConfig, flavor, llmParameters);
    }

    public CompletionSession createSession(String projectId, String environment) {
        String sessionId = this.callSupport.createSession(projectId, environment);
        Collection<PromptTemplate> prompts = this.callSupport.getPrompts(projectId, environment);
        return new CompletionSession(this.callSupport, sessionId, prompts, environment);
    }

    public CompletionResponse getCompletion(String projectId, String templateName, Map<String, Object> variables, String environment) throws FreeplayException {
        return this.getCompletion(projectId, templateName, variables, Collections.emptyMap(), environment);
    }

    public CompletionResponse getCompletion(String projectId, String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, String environment) throws FreeplayException {
        return this.getCompletion(projectId, templateName, variables, llmParameters, environment, null, null);
    }

    public <P> CompletionResponse getCompletion(String projectId, String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, String environment, Flavor<P, CompletionResponse> flavor) throws FreeplayException {
        return this.getCompletion(projectId, templateName, variables, llmParameters, environment, flavor, null);
    }

    public <P> CompletionResponse getCompletion(String projectId, String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, String environment, PromptProcessor<P> promptProcessor) throws FreeplayException {
        return this.getCompletion(projectId, templateName, variables, llmParameters, environment, null, promptProcessor);
    }

    public <P> CompletionResponse getCompletion(String projectId, String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, String environment, Flavor<P, CompletionResponse> flavor, PromptProcessor<P> promptProcessor) throws FreeplayException {
        String sessionId = this.callSupport.createSession(projectId, environment);
        Collection<PromptTemplate> prompts = this.callSupport.getPrompts(projectId, environment);
        return this.callSupport.prepareAndMakeCall(sessionId, prompts, templateName, variables, llmParameters, environment, null, flavor, promptProcessor);
    }

    public ChatStart<IndexedChatMessage> startChat(String projectId, String templateName, Map<String, Object> variables, String environment) throws FreeplayException {
        return this.startChat(projectId, templateName, variables, Collections.emptyMap(), environment);
    }

    public ChatStart<IndexedChatMessage> startChat(String projectId, String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, String environment) throws FreeplayException {
        return this.startChat(projectId, templateName, variables, llmParameters, environment, null);
    }

    public ChatStart<IndexedChatMessage> startChat(String projectId, String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, String environment, ChatFlavor flavor) throws FreeplayException {
        String sessionId = this.callSupport.createSession(projectId, environment);
        Collection<PromptTemplate> prompts = this.callSupport.getPrompts(projectId, environment);
        ChatSession chatSession = new ChatSession(this.callSupport, sessionId, prompts, templateName, environment);
        return chatSession.startChat(variables, llmParameters, environment, flavor);
    }

    public ChatStart<Stream<IndexedChatMessage>> startChatStream(String projectId, String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, String environment) throws FreeplayException {
        return this.startChatStream(projectId, templateName, variables, llmParameters, environment, null);
    }

    public ChatStart<Stream<IndexedChatMessage>> startChatStream(String projectId, String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, String environment, ChatFlavor flavor) throws FreeplayException {
        String sessionId = this.callSupport.createSession(projectId, environment);
        Collection<PromptTemplate> prompts = this.callSupport.getPrompts(projectId, environment);
        ChatSession chatSession = new ChatSession(this.callSupport, sessionId, prompts, templateName, environment);
        return new ChatStart<Stream<IndexedChatMessage>>(chatSession, chatSession.startChatStream(variables, llmParameters, environment, flavor));
    }

    public TestRun createTestRun(String projectId, String environment, String testListName) {
        return this.callSupport.createTestRun(projectId, environment, testListName);
    }
}

