/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.flavor;

import ai.freeplay.client.ProviderConfig;
import ai.freeplay.client.exceptions.FreeplayException;
import ai.freeplay.client.flavor.Flavor;
import ai.freeplay.client.internal.Http;
import ai.freeplay.client.internal.JSONUtil;
import ai.freeplay.client.model.Provider;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class OpenAIFlavor<P, R>
implements Flavor<P, R> {
    @Override
    public Provider getProviderEnum() {
        return Provider.OpenAI;
    }

    protected static void validateChoices(List<Map<String, Object>> choices) throws FreeplayException {
        if (choices.isEmpty()) {
            throw new FreeplayException("Did not get any 'choices' back from OpenAI.");
        }
    }

    protected static void validateParameters(Map<String, Object> llmParameters) {
        if (!llmParameters.containsKey("model")) {
            throw new FreeplayException("The 'model' parameter is required when calling OpenAI");
        }
        if (llmParameters.containsKey("prompt")) {
            throw new FreeplayException("The 'prompt' parameter cannot be specified. It is populated automatically.");
        }
        if (llmParameters.containsKey("messages")) {
            throw new FreeplayException("The 'messages' parameter cannot be specified. It is populated automatically.");
        }
    }

    protected Stream<String> callOpenAIStream(ProviderConfig providerConfig, String url, String promptFieldName, Map<String, Object> mergedLLMParameters, P formattedPrompt) {
        HttpResponse<Stream<String>> response;
        OpenAIFlavor.validateParameters(mergedLLMParameters);
        HashMap<String, Object> bodyMap = new HashMap<String, Object>(mergedLLMParameters);
        bodyMap.put(promptFieldName, formattedPrompt);
        bodyMap.put("stream", true);
        try {
            response = Http.postJsonWithBearer(url, bodyMap, providerConfig.getApiKey(), HttpResponse.BodyHandlers.ofLines());
        }
        catch (Exception e) {
            throw new FreeplayException("Error calling OpenAI.", e);
        }
        return response.body();
    }

    protected R parseLine(String line, Function<Map<String, Object>, R> itemCreator) {
        String[] field = line.split(":", 2);
        if (field.length == 2 && "data".equals(field[0])) {
            if ("[DONE]".equals(field[1].trim())) {
                return null;
            }
            Map<String, Object> objectMap = JSONUtil.parseMap(field[1]);
            List choices = (List)objectMap.get("choices");
            Map firstChoice = (Map)choices.get(0);
            return itemCreator.apply(firstChoice);
        }
        throw new FreeplayException("Got unknown line in the stream: '" + line + "'");
    }
}

