/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.flavor;

import ai.freeplay.client.HttpConfig;
import ai.freeplay.client.ProviderConfig;
import ai.freeplay.client.exceptions.FreeplayException;
import ai.freeplay.client.flavor.OpenAIFlavor;
import ai.freeplay.client.internal.Http;
import ai.freeplay.client.internal.StringUtils;
import ai.freeplay.client.internal.TemplateUtils;
import ai.freeplay.client.model.CompletionResponse;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class OpenAITextFlavor
extends OpenAIFlavor<String, CompletionResponse> {
    private static final String OPENAI_COMPLETIONS_URL = "https://api.openai.com/v1/completions";

    @Override
    public String formatPrompt(String template, Map<String, Object> variables) {
        return TemplateUtils.format(template, variables);
    }

    @Override
    public CompletionResponse callService(String formattedPrompt, ProviderConfig providerConfig, Map<String, Object> mergedLLMParameters, HttpConfig httpConfig) throws FreeplayException {
        HttpResponse<String> response;
        OpenAITextFlavor.validateParameters(mergedLLMParameters);
        HashMap<String, Object> bodyMap = new HashMap<String, Object>(mergedLLMParameters);
        bodyMap.put("prompt", formattedPrompt);
        try {
            response = Http.postJsonWithBearer(OPENAI_COMPLETIONS_URL, bodyMap, providerConfig.getApiKey(), httpConfig);
        }
        catch (Exception e) {
            throw new FreeplayException("Error calling OpenAI.", e);
        }
        Map<String, Object> responseBody = Http.parseBody(response);
        Http.throwIfError(response, 200);
        List choices = (List)responseBody.get("choices");
        OpenAITextFlavor.validateChoices(choices);
        Map choice = (Map)choices.get(0);
        boolean isComplete = "stop".equals(choice.get("finish_reason"));
        return new CompletionResponse(String.valueOf(choice.get("text")), isComplete, true);
    }

    @Override
    public String getFormatType() {
        return "openai_text";
    }

    @Override
    public String serializeForRecord(String formattedPrompt) {
        return formattedPrompt;
    }

    @Override
    public Stream<CompletionResponse> callServiceStream(String formattedPrompt, ProviderConfig providerConfig, Map<String, Object> mergedLLMParameters, HttpConfig httpConfig) {
        Stream<String> messages = this.callOpenAIStream(providerConfig, OPENAI_COMPLETIONS_URL, "prompt", mergedLLMParameters, formattedPrompt, httpConfig);
        return messages.filter(StringUtils::isNotBlank).map(line -> this.parseLine((String)line, this::createItem)).filter(Objects::nonNull);
    }

    @Override
    public String getContentFromChunk(CompletionResponse chunk) {
        return chunk.getContent();
    }

    @Override
    public boolean isLastChunk(CompletionResponse chunk) {
        return chunk.isLast();
    }

    @Override
    public boolean isComplete(CompletionResponse chunk) {
        return chunk.isComplete();
    }

    protected CompletionResponse createItem(Map<String, Object> firstChoice) {
        Object text = firstChoice.get("text");
        boolean isComplete = "stop".equals(firstChoice.get("finish_reason"));
        if (StringUtils.isBlank(text) && firstChoice.get("finish_reason") != null) {
            return new CompletionResponse("", isComplete, true);
        }
        return new CompletionResponse(String.valueOf(text), isComplete, false);
    }
}

