/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.internal;

import ai.freeplay.client.HttpConfig;
import ai.freeplay.client.exceptions.FreeplayException;
import ai.freeplay.client.internal.JSONUtil;
import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class Http {
    public static HttpResponse<String> postWithBearer(String url, String apiKey, HttpConfig httpConfig) throws FreeplayException {
        return Http.postJsonWithBearer(url, null, apiKey, HttpResponse.BodyHandlers.ofString(), httpConfig);
    }

    public static HttpResponse<String> postJsonWithBearer(String url, Map<String, Object> body, String apiKey) throws FreeplayException {
        String jsonString = JSONUtil.asString(body);
        return Http.postJsonWithBearer(url, jsonString, apiKey, HttpResponse.BodyHandlers.ofString(), new HttpConfig(), new String[0]);
    }

    public static HttpResponse<String> postJsonWithBearer(String url, Map<String, Object> body, String apiKey, HttpConfig httpConfig) throws FreeplayException {
        String jsonString = JSONUtil.asString(body);
        return Http.postJsonWithBearer(url, jsonString, apiKey, HttpResponse.BodyHandlers.ofString(), httpConfig, new String[0]);
    }

    public static <R> HttpResponse<R> postJsonWithBearer(String url, Map<String, Object> body, String apiKey, HttpResponse.BodyHandler<R> responseBodyHandler, HttpConfig httpConfig) throws FreeplayException {
        return Http.postJsonWithBearer(url, JSONUtil.asString(body), apiKey, responseBodyHandler, httpConfig, new String[0]);
    }

    public static <R> HttpResponse<R> postJsonWithBearer(String url, String body, String apiKey, HttpResponse.BodyHandler<R> responseBodyHandler, HttpConfig httpConfig, String ... headers) throws FreeplayException {
        ArrayList<String> allHeadersArray = new ArrayList<String>(headers.length + 3);
        Collections.addAll(allHeadersArray, headers);
        allHeadersArray.add("Authorization");
        allHeadersArray.add(String.format("Bearer %s", apiKey));
        String[] allHeaders = allHeadersArray.toArray(new String[0]);
        return Http.postJson(url, body, responseBodyHandler, httpConfig, allHeaders);
    }

    public static HttpResponse<String> postJson(String url, Map<String, Object> body, HttpConfig httpConfig, String ... headers) throws FreeplayException {
        return Http.postJson(url, body, HttpResponse.BodyHandlers.ofString(), httpConfig, headers);
    }

    public static <R> HttpResponse<R> postJson(String url, Map<String, Object> body, HttpResponse.BodyHandler<R> responseBodyHandler, HttpConfig httpConfig, String ... headers) throws FreeplayException {
        String jsonString = JSONUtil.asString(body);
        return Http.postJson(url, jsonString, responseBodyHandler, httpConfig, headers);
    }

    public static <R> HttpResponse<R> postJson(String url, String body, HttpResponse.BodyHandler<R> responseBodyHandler, HttpConfig httpConfig, String ... headers) throws FreeplayException {
        HttpRequest.Builder requestBuilder;
        HttpRequest.BodyPublisher bodyPublisher = body != null ? HttpRequest.BodyPublishers.ofString(body) : HttpRequest.BodyPublishers.noBody();
        try {
            requestBuilder = HttpRequest.newBuilder(new URI(url)).header("Content-Type", "application/json").headers(headers).POST(bodyPublisher);
            if (httpConfig.getRequestTimeout() != null) {
                requestBuilder.timeout(httpConfig.getRequestTimeout());
            }
        }
        catch (URISyntaxException e) {
            throw new FreeplayException("Error in URL during POST request. ", e);
        }
        try {
            HttpClient.Builder clientBuilder = HttpClient.newBuilder();
            if (httpConfig.getExecutor() != null) {
                clientBuilder.executor(httpConfig.getExecutor());
            }
            if (httpConfig.getProxySelector() != null) {
                clientBuilder.proxy(httpConfig.getProxySelector());
            }
            return clientBuilder.build().send(requestBuilder.build(), responseBodyHandler);
        }
        catch (Exception e) {
            throw new FreeplayException("Error sending POST request.", e);
        }
    }

    public static HttpResponse<String> get(String url, String apiKey) throws FreeplayException {
        return Http.get(url, apiKey, new HttpConfig());
    }

    public static HttpResponse<String> get(String url, String apiKey, HttpConfig httpConfig) throws FreeplayException {
        HttpRequest.Builder requestBuilder;
        try {
            requestBuilder = HttpRequest.newBuilder(new URI(url));
        }
        catch (URISyntaxException e) {
            throw new FreeplayException("Error in URL during GET request. ", e);
        }
        if (apiKey != null) {
            requestBuilder.header("Authorization", String.format("Bearer %s", apiKey));
        }
        if (httpConfig.getRequestTimeout() != null) {
            requestBuilder.timeout(httpConfig.getRequestTimeout());
        }
        try {
            HttpClient.Builder clientBuilder = HttpClient.newBuilder();
            if (httpConfig.getExecutor() != null) {
                clientBuilder.executor(httpConfig.getExecutor());
            }
            if (httpConfig.getProxySelector() != null) {
                clientBuilder.proxy(httpConfig.getProxySelector());
            }
            return clientBuilder.build().send(requestBuilder.build(), HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception e) {
            throw new FreeplayException("Error sending GET request.", e);
        }
    }

    public static Map<String, Object> parseBody(HttpResponse<String> response) throws FreeplayException {
        try {
            return JSON.std.mapFrom((Object)response.body());
        }
        catch (IOException e) {
            throw new FreeplayException("Unable to parse JSON.", e);
        }
    }

    public static void throwIfError(HttpResponse<String> response, int expectedStatus) throws FreeplayException {
        if (response.statusCode() != expectedStatus) {
            Map<String, Object> bodyMap = Http.parseBody(response);
            Object message = bodyMap.get("message");
            if (message != null) {
                throw new FreeplayException(String.format("Error making call [%s]: %s", response.statusCode(), message));
            }
            throw new FreeplayException(String.format("Error making call [%s]", response.statusCode()));
        }
    }
}

