/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.flavor;

import ai.freeplay.client.HttpConfig;
import ai.freeplay.client.ProviderConfig;
import ai.freeplay.client.ProviderConfigs;
import ai.freeplay.client.exceptions.FreeplayClientException;
import ai.freeplay.client.exceptions.FreeplayException;
import ai.freeplay.client.exceptions.LLMServerException;
import ai.freeplay.client.flavor.ChatFlavor;
import ai.freeplay.client.flavor.OpenAIFlavor;
import ai.freeplay.client.internal.Http;
import ai.freeplay.client.internal.JSONUtil;
import ai.freeplay.client.internal.StringUtils;
import ai.freeplay.client.internal.TemplateUtils;
import ai.freeplay.client.model.ChatCompletionResponse;
import ai.freeplay.client.model.ChatMessage;
import ai.freeplay.client.model.CompletionResponse;
import ai.freeplay.client.model.IndexedChatMessage;
import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.net.http.HttpResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OpenAIChatFlavor
extends OpenAIFlavor<Collection<ChatMessage>, IndexedChatMessage>
implements ChatFlavor {
    private static final String OPENAI_CHAT_URL = "https://api.openai.com/v1/chat/completions";

    @Override
    public String getFormatType() {
        return "openai_chat";
    }

    @Override
    public Collection<ChatMessage> formatPrompt(String template, Map<String, Object> variables) {
        try {
            return JSON.std.listFrom((Object)template).stream().map(message -> {
                Map messageMap = (Map)message;
                String formatted = TemplateUtils.format(String.valueOf(messageMap.get("content")), variables);
                return new ChatMessage(String.valueOf(messageMap.get("role")), formatted);
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new FreeplayClientException("Error formatting chat prompt template.", e);
        }
    }

    @Override
    public CompletionResponse callService(Collection<ChatMessage> formattedMessages, ProviderConfigs providerConfig, Map<String, Object> mergedLLMParameters, HttpConfig httpConfig) throws FreeplayException {
        ChatCompletionResponse chatResponse = this.callChatService(formattedMessages, providerConfig, mergedLLMParameters, httpConfig);
        return new CompletionResponse(chatResponse.getContent(), chatResponse.isComplete(), true);
    }

    @Override
    public ChatCompletionResponse callChatService(Collection<ChatMessage> formattedMessages, ProviderConfigs providerConfig, Map<String, Object> llmParameters, HttpConfig httpConfig) throws FreeplayException {
        Map<String, Object> responseBody;
        HttpResponse<String> response;
        OpenAIChatFlavor.validateParameters(llmParameters);
        ProviderConfig.OpenAIProviderConfig openAIProviderConfig = this.validateConfig(providerConfig);
        HashMap<String, Object> bodyMap = new HashMap<String, Object>(llmParameters);
        bodyMap.put("messages", formattedMessages);
        try {
            response = Http.postJsonWithBearer(OPENAI_CHAT_URL, bodyMap, openAIProviderConfig.getApiKey(), httpConfig);
        }
        catch (Exception e) {
            throw new LLMServerException("Error calling OpenAI.", e);
        }
        try {
            responseBody = Http.parseBody(response);
        }
        catch (FreeplayException e) {
            throw new LLMServerException("Error calling OpenAI.", e);
        }
        Http.throwLLMIfError(response, 200);
        List choices = (List)responseBody.get("choices");
        OpenAIChatFlavor.validateChoices(choices);
        List<IndexedChatMessage> choiceMessages = choices.stream().map(messageObject -> {
            Map messageMap = (Map)messageObject.get("message");
            boolean isComplete = "stop".equals(messageObject.get("finish_reason"));
            return new IndexedChatMessage(String.valueOf(messageMap.get("role")), String.valueOf(messageMap.get("content")), (Integer)messageObject.get("index"), isComplete);
        }).collect(Collectors.toList());
        return new ChatCompletionResponse(choiceMessages);
    }

    @Override
    public Stream<IndexedChatMessage> callServiceStream(Collection<ChatMessage> formattedPrompt, ProviderConfigs providerConfig, Map<String, Object> mergedLLMParameters, HttpConfig httpConfig) {
        Stream<String> messages = this.callOpenAIStream(providerConfig, OPENAI_CHAT_URL, "messages", mergedLLMParameters, formattedPrompt, httpConfig);
        AtomicReference role = new AtomicReference();
        Function<Map, IndexedChatMessage> itemCreator = choice -> this.createItem((Map<String, Object>)choice, role);
        return messages.filter(StringUtils::isNotBlank).map(line -> (IndexedChatMessage)this.parseLine((String)line, itemCreator)).filter(Objects::nonNull);
    }

    @Override
    public String getContentFromChunk(IndexedChatMessage chunk) {
        return chunk.getContent();
    }

    @Override
    public boolean isLastChunk(IndexedChatMessage chunk) {
        return chunk.isLast();
    }

    @Override
    public boolean isComplete(IndexedChatMessage chunk) {
        return chunk.isComplete();
    }

    @Override
    public String serializeForRecord(Collection<ChatMessage> formattedMessages) {
        try {
            return JSONUtil.asString(formattedMessages);
        }
        catch (Exception e) {
            throw new LLMServerException("Error processing messages from OpenAI.", e);
        }
    }

    private IndexedChatMessage createItem(Map<String, Object> choice, AtomicReference<String> roleReference) {
        Map delta = (Map)choice.get("delta");
        if (delta.get("role") != null) {
            roleReference.set(String.valueOf(delta.get("role")));
        }
        boolean isComplete = "stop".equals(choice.get("finish_reason"));
        Object content = delta.get("content");
        if (StringUtils.isBlank(content) && choice.get("finish_reason") != null) {
            return new IndexedChatMessage(roleReference.get(), "", 0, isComplete, true);
        }
        return new IndexedChatMessage(roleReference.get(), String.valueOf(content), 0, isComplete, false);
    }
}

