/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.model;

import ai.freeplay.client.exceptions.FreeplayConfigurationException;
import ai.freeplay.client.exceptions.FreeplayException;
import ai.freeplay.client.exceptions.LLMServerException;
import ai.freeplay.client.flavor.ChatFlavor;
import ai.freeplay.client.internal.CallSupport;
import ai.freeplay.client.model.ChatCompletionResponse;
import ai.freeplay.client.model.ChatMessage;
import ai.freeplay.client.model.ChatStart;
import ai.freeplay.client.model.IndexedChatMessage;
import ai.freeplay.client.model.PromptTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ChatSession {
    private final CallSupport callSupport;
    private final String sessionId;
    private final PromptTemplate targetTemplate;
    private final List<ChatMessage> messageHistory = new ArrayList<ChatMessage>();
    private Map<String, Object> variables;
    private String tag;
    private final String testRunId;

    public ChatSession(CallSupport callSupport, String sessionId, Collection<PromptTemplate> prompts, String templateName, String tag) throws FreeplayException {
        this.testRunId = null;
        this.callSupport = callSupport;
        this.sessionId = sessionId;
        this.targetTemplate = callSupport.findPrompt(prompts, templateName).orElseThrow(() -> new FreeplayConfigurationException("Cannot find template " + templateName + " in environment " + tag + "."));
    }

    public ChatStart<IndexedChatMessage> startChat(Map<String, Object> variables, Map<String, Object> llmParameters, String environment, ChatFlavor flavor) {
        this.variables = variables;
        this.tag = environment;
        ChatFlavor activeFlavor = this.callSupport.getActiveFlavor(flavor, this.targetTemplate);
        Collection<ChatMessage> formattedMessages = activeFlavor.formatPrompt(this.targetTemplate.getContent(), this.variables);
        ChatCompletionResponse response = this.continueChat(formattedMessages, llmParameters);
        return new ChatStart<IndexedChatMessage>(this, response.getFirstChoice().orElseThrow(() -> new LLMServerException("Did not receive a choice within the chat response.")));
    }

    public ChatCompletionResponse continueChat(ChatMessage newMessage) {
        return this.continueChat(List.of(newMessage), Collections.emptyMap());
    }

    public ChatCompletionResponse continueChat(ChatMessage newMessage, Map<String, Object> llmParameters) {
        return this.continueChat(List.of(newMessage), llmParameters);
    }

    public ChatCompletionResponse continueChat(Collection<ChatMessage> newMessages, Map<String, Object> llmParameters) {
        this.messageHistory.addAll(newMessages);
        List<ChatMessage> cleanMessages = this.toCleanMessages(this.messageHistory);
        ChatCompletionResponse response = this.callSupport.makeContinueChatCall(this.sessionId, this.targetTemplate, cleanMessages, this.variables, llmParameters, this.tag, this.testRunId, null);
        if (response.getFirstChoice().isPresent()) {
            this.messageHistory.add(response.getFirstChoice().get());
        }
        return response;
    }

    public Stream<IndexedChatMessage> startChatStream(Map<String, Object> variables, Map<String, Object> llmParameters, String environment, ChatFlavor flavor) {
        this.variables = variables;
        this.tag = environment;
        ChatFlavor activeFlavor = this.callSupport.getActiveFlavor(flavor, this.targetTemplate);
        Collection<ChatMessage> formattedMessages = activeFlavor.formatPrompt(this.targetTemplate.getContent(), this.variables);
        return this.continueChatStream(formattedMessages, llmParameters);
    }

    public Stream<IndexedChatMessage> continueChatStream(ChatMessage newMessage, Map<String, Object> llmParameters) {
        return this.continueChatStream(List.of(newMessage), llmParameters);
    }

    public Stream<IndexedChatMessage> continueChatStream(Collection<ChatMessage> newMessages, Map<String, Object> llmParameters) {
        this.messageHistory.addAll(newMessages);
        List<ChatMessage> cleanMessages = this.toCleanMessages(this.messageHistory);
        Stream<IndexedChatMessage> response = this.callSupport.makeContinueChatCallStream(this.sessionId, this.targetTemplate, cleanMessages, this.variables, llmParameters, this.tag, this.testRunId);
        AtomicReference<String> aggregatedContent = new AtomicReference<String>("");
        return response.peek(message -> {
            aggregatedContent.getAndUpdate(previous -> previous + message.getContent());
            if (message.isLast()) {
                this.messageHistory.add(new ChatMessage(message.getRole(), (String)aggregatedContent.get()));
            }
        });
    }

    public List<ChatMessage> getMessageHistory() {
        return this.messageHistory;
    }

    public Optional<ChatMessage> getLastMessage() {
        if (this.messageHistory.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.messageHistory.get(this.messageHistory.size() - 1));
    }

    private List<ChatMessage> toCleanMessages(List<ChatMessage> messageHistory) {
        return messageHistory.stream().map(message -> message instanceof IndexedChatMessage ? new ChatMessage(message.getRole(), message.getContent()) : message).collect(Collectors.toList());
    }
}

