/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.model;

import ai.freeplay.client.internal.CallSupport;
import ai.freeplay.client.model.CompletionSession;
import ai.freeplay.client.model.PromptTemplate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TestRun {
    private final CallSupport callSupport;
    private final String projectId;
    private final String environment;
    private final String testRunId;
    private final List<Map<String, Object>> inputs;

    public TestRun(CallSupport callSupport, String projectId, String environment, String testRunId, List<Map<String, Object>> inputs) {
        this.callSupport = callSupport;
        this.projectId = projectId;
        this.environment = environment;
        this.testRunId = testRunId;
        this.inputs = inputs;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getTestRunId() {
        return this.testRunId;
    }

    public List<Map<String, Object>> getInputs() {
        return this.inputs;
    }

    public CompletionSession createSession() {
        return this.createSession(Collections.emptyMap());
    }

    public CompletionSession createSession(Map<String, Object> metadata) {
        String sessionId = this.callSupport.createSession(this.projectId, this.environment, metadata);
        Collection<PromptTemplate> prompts = this.callSupport.getPrompts(this.projectId, this.environment);
        return new CompletionSession(this.callSupport, sessionId, prompts, this.environment, this.testRunId);
    }
}

