/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.model;

import ai.freeplay.client.exceptions.FreeplayConfigurationException;
import ai.freeplay.client.flavor.ChatFlavor;
import ai.freeplay.client.internal.CallSupport;
import ai.freeplay.client.model.ChatCompletionResponse;
import ai.freeplay.client.model.CompletionResponse;
import ai.freeplay.client.model.IndexedChatMessage;
import ai.freeplay.client.model.PromptTemplate;
import ai.freeplay.client.processor.ChatPromptProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;

public class CompletionSession {
    private final CallSupport callSupport;
    private final String sessionId;
    private final Collection<PromptTemplate> promptTemplates;
    private final String tag;
    private final String testRunId;

    public CompletionSession(CallSupport callSupport, String sessionId, Collection<PromptTemplate> prompts, String environment) {
        this(callSupport, sessionId, prompts, environment, null);
    }

    public CompletionSession(CallSupport callSupport, String sessionId, Collection<PromptTemplate> prompts, String environment, String testRunId) {
        this.callSupport = callSupport;
        this.sessionId = sessionId;
        this.promptTemplates = prompts;
        this.tag = environment;
        this.testRunId = testRunId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public CompletionResponse getCompletion(String templateName, Map<String, Object> variables) {
        return this.getCompletion(templateName, variables, Collections.emptyMap(), null, null);
    }

    public CompletionResponse getCompletion(String templateName, Map<String, Object> variables, Map<String, Object> llmParameters) {
        return this.getCompletion(templateName, variables, llmParameters, null, null);
    }

    public CompletionResponse getCompletion(String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, ChatPromptProcessor promptProcessor) {
        return this.getCompletion(templateName, variables, llmParameters, null, promptProcessor);
    }

    public CompletionResponse getCompletion(String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, ChatFlavor flavor) {
        return this.getCompletion(templateName, variables, llmParameters, flavor, null);
    }

    public CompletionResponse getCompletion(String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, ChatFlavor flavor, ChatPromptProcessor promptProcessor) {
        return this.callSupport.prepareAndMakeCall(this.getSessionId(), this.promptTemplates, templateName, variables, llmParameters, this.tag, this.testRunId, flavor, promptProcessor);
    }

    public Stream<IndexedChatMessage> getCompletionStream(String templateName, Map<String, Object> variables) {
        return this.getCompletionStream(templateName, variables, Collections.emptyMap(), null, null, null);
    }

    public Stream<IndexedChatMessage> getCompletionStream(String templateName, Map<String, Object> variables, Map<String, Object> llmParameters) {
        return this.getCompletionStream(templateName, variables, llmParameters, null, null, null);
    }

    public Stream<IndexedChatMessage> getCompletionStream(String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, String testRunId, ChatFlavor flavor) {
        return this.getCompletionStream(templateName, variables, llmParameters, testRunId, flavor, null);
    }

    public Stream<IndexedChatMessage> getCompletionStream(String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, String testRunId, ChatPromptProcessor promptProcessor) {
        return this.getCompletionStream(templateName, variables, llmParameters, testRunId, null, promptProcessor);
    }

    public Stream<IndexedChatMessage> getCompletionStream(String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, String testRunId, ChatFlavor flavor, ChatPromptProcessor promptProcessor) {
        PromptTemplate template = this.callSupport.findPrompt(this.promptTemplates, templateName).orElseThrow(() -> new FreeplayConfigurationException("Unable to find prompt template with name " + templateName + " in environment " + this.tag));
        return this.callSupport.makeCallStream(this.getSessionId(), template, variables, llmParameters, this.tag, testRunId, flavor, promptProcessor);
    }

    public ChatCompletionResponse getChatCompletion(String templateName, Map<String, Object> variables) {
        return this.getChatCompletion(templateName, variables, Collections.emptyMap(), null, null, null);
    }

    public ChatCompletionResponse getChatCompletion(String templateName, Map<String, Object> variables, Map<String, Object> llmParameters) {
        return this.getChatCompletion(templateName, variables, llmParameters, null, null, null);
    }

    public ChatCompletionResponse getChatCompletion(String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, ChatPromptProcessor promptProcessor) {
        return this.getChatCompletion(templateName, variables, llmParameters, null, null, promptProcessor);
    }

    public ChatCompletionResponse getChatCompletion(String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, String testRunId, ChatFlavor flavor, ChatPromptProcessor promptProcessor) {
        return this.callSupport.makeContinueChatCall(this.sessionId, this.promptTemplates, templateName, variables, llmParameters, this.tag, testRunId, flavor, promptProcessor);
    }
}

