/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.processor;

import ai.freeplay.client.exceptions.FreeplayConfigurationException;
import ai.freeplay.client.exceptions.FreeplayException;
import ai.freeplay.client.internal.JSONUtil;
import ai.freeplay.client.model.PromptTemplate;
import ai.freeplay.client.processor.TemplateResolver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class FilesystemTemplateResolver
implements TemplateResolver {
    private final Path promptsDirectory;

    public FilesystemTemplateResolver(Path rootDirectory) {
        if (!Files.isDirectory(rootDirectory, new LinkOption[0])) {
            throw new FreeplayConfigurationException(String.format("Path for templates is not a directory. [%s]%n", rootDirectory.toAbsolutePath()));
        }
        this.promptsDirectory = rootDirectory.resolve("freeplay/prompts");
        if (!Files.isDirectory(this.promptsDirectory, new LinkOption[0])) {
            throw new FreeplayConfigurationException(String.format("Path for templates does not appear to be a Freeplay prompts directory. [%s]%n", rootDirectory.toAbsolutePath()));
        }
    }

    @Override
    public Collection<PromptTemplate> getPrompts(String projectId, String environment) {
        Path environmentDir = this.promptsDirectory.resolve(projectId + "/" + environment);
        if (!Files.exists(environmentDir, new LinkOption[0])) {
            throw new FreeplayConfigurationException(String.format("Could not find directory for project %s and environment %s.%n", projectId, environment));
        }
        return Arrays.stream(Objects.requireNonNull(environmentDir.toFile().listFiles((dir, name) -> name.endsWith(".json")))).map(this::toPromptTemplate).collect(Collectors.toList());
    }

    private PromptTemplate toPromptTemplate(File templateFile) {
        Map<String, Object> docMap;
        File promptAbsoluteFile = templateFile.getAbsoluteFile();
        try {
            docMap = JSONUtil.parseMap(Files.readString(promptAbsoluteFile.toPath()));
        }
        catch (FreeplayException | IOException e) {
            throw new FreeplayConfigurationException(String.format("Unable to read prompt file %s.%n", promptAbsoluteFile.toPath()), e);
        }
        Map metdataMap = (Map)docMap.get("metadata");
        return new PromptTemplate((String)docMap.get("name"), (String)docMap.get("content"), (String)metdataMap.get("flavor_name"), (String)docMap.get("prompt_template_version_id"), (String)docMap.get("prompt_template_id"), (String)docMap.get("prompt_template_version_id"), (Map)metdataMap.get("params"));
    }
}

