/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.internal;

import ai.freeplay.client.HttpConfig;
import ai.freeplay.client.exceptions.FreeplayException;
import ai.freeplay.client.internal.UserAgent;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncHttp {
    public static CompletableFuture<HttpResponse<String>> get(String url, String apiKey, HttpConfig httpConfig) throws FreeplayException {
        HttpRequest.Builder requestBuilder;
        try {
            requestBuilder = HttpRequest.newBuilder(new URI(url));
        }
        catch (URISyntaxException e) {
            throw new FreeplayException("Error in URL during GET request.", e);
        }
        if (apiKey != null) {
            requestBuilder.header("Authorization", String.format("Bearer %s", apiKey));
        }
        requestBuilder.header("User-Agent", UserAgent.getUserAgent());
        if (httpConfig.getRequestTimeout() != null) {
            requestBuilder.timeout(httpConfig.getRequestTimeout());
        }
        try {
            HttpClient.Builder clientBuilder = HttpClient.newBuilder();
            if (httpConfig.getExecutor() != null) {
                clientBuilder.executor(httpConfig.getExecutor());
            }
            if (httpConfig.getProxySelector() != null) {
                clientBuilder.proxy(httpConfig.getProxySelector());
            }
            return clientBuilder.build().sendAsync(requestBuilder.build(), HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception e) {
            throw new FreeplayException("Error sending GET request.", e);
        }
    }
}

