/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.processor;

import ai.freeplay.client.exceptions.FreeplayConfigurationException;
import ai.freeplay.client.model.PromptTemplate;
import ai.freeplay.client.processor.TemplateResolver;
import ai.freeplay.client.thin.internal.model.Templates;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class FilesystemTemplateResolver
implements TemplateResolver {
    private final ai.freeplay.client.thin.FilesystemTemplateResolver thinResolver;

    public FilesystemTemplateResolver(Path rootDirectory) {
        this.thinResolver = new ai.freeplay.client.thin.FilesystemTemplateResolver(rootDirectory);
    }

    @Override
    public Collection<PromptTemplate> getPrompts(String projectId, String environment) {
        try {
            Templates prompts = this.thinResolver.getPrompts(projectId, environment).get();
            return prompts.getTemplates().stream().map(template -> new PromptTemplate(template.getName(), template.getContent(), template.getFlavorName(), template.getPromptTemplateVersionId(), template.getPromptTemplateId(), template.getPromptTemplateVersionId(), template.getParams())).collect(Collectors.toList());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new FreeplayConfigurationException(String.format("Unable to get prompts for project %s, environment %s%n.", projectId, environment), e);
        }
    }
}

