/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin;

import ai.freeplay.client.HttpConfig;
import ai.freeplay.client.internal.AsyncHttp;
import ai.freeplay.client.internal.Http;
import ai.freeplay.client.internal.JSONUtil;
import ai.freeplay.client.thin.TemplateResolver;
import ai.freeplay.client.thin.internal.model.Templates;
import java.util.concurrent.CompletableFuture;

public class APITemplateResolver
implements TemplateResolver {
    private final String baseUrl;
    private final String freeplayApiKey;
    private final HttpConfig httpConfig;

    public APITemplateResolver(String baseUrl, String freeplayApiKey, HttpConfig httpConfig) {
        this.baseUrl = baseUrl;
        this.freeplayApiKey = freeplayApiKey;
        this.httpConfig = httpConfig;
    }

    @Override
    public CompletableFuture<Templates> getPrompts(String projectId, String environment) {
        String url = String.format("%s/projects/%s/templates/all/%s", this.baseUrl, projectId, environment);
        return AsyncHttp.get(url, this.freeplayApiKey, this.httpConfig).thenApply(response -> {
            Http.throwFreeplayIfError(response, 200);
            return JSONUtil.parse((String)response.body(), Templates.class);
        });
    }
}

