/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin;

import ai.freeplay.client.exceptions.FreeplayConfigurationException;
import ai.freeplay.client.internal.JSONUtil;
import ai.freeplay.client.thin.TemplateResolver;
import ai.freeplay.client.thin.internal.model.LocalTemplate;
import ai.freeplay.client.thin.internal.model.Template;
import ai.freeplay.client.thin.internal.model.Templates;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class FilesystemTemplateResolver
implements TemplateResolver {
    private final Path promptsDirectory;

    public FilesystemTemplateResolver(Path rootDirectory) {
        if (!Files.isDirectory(rootDirectory, new LinkOption[0])) {
            throw new FreeplayConfigurationException(String.format("Path for templates is not a directory. [%s]%n", rootDirectory.toAbsolutePath()));
        }
        this.promptsDirectory = rootDirectory.resolve("freeplay/prompts");
        if (!Files.isDirectory(this.promptsDirectory, new LinkOption[0])) {
            throw new FreeplayConfigurationException(String.format("Path for templates does not appear to be a Freeplay prompts directory. [%s]%n", rootDirectory.toAbsolutePath()));
        }
    }

    @Override
    public CompletableFuture<Templates> getPrompts(String projectId, String environment) {
        Path environmentDir = this.promptsDirectory.resolve(projectId + "/" + environment);
        if (!Files.exists(environmentDir, new LinkOption[0])) {
            throw new FreeplayConfigurationException(String.format("Could not find directory for project %s and environment %s.%n", projectId, environment));
        }
        List<Template> templateList = Arrays.stream(Objects.requireNonNull(environmentDir.toFile().listFiles((dir, name) -> name.endsWith(".json")))).map(this::toTemplate).collect(Collectors.toList());
        return CompletableFuture.completedFuture(new Templates(templateList));
    }

    private Template toTemplate(File templateFile) {
        File promptAbsoluteFile = templateFile.getAbsoluteFile();
        try {
            LocalTemplate localTemplate = JSONUtil.parse(Files.readString(promptAbsoluteFile.toPath()), LocalTemplate.class);
            return new Template(localTemplate.getName(), localTemplate.getContent(), localTemplate.getMetadata().getFlavorName(), localTemplate.getPromptTemplateId(), localTemplate.getPromptTemplateVersionId(), localTemplate.getMetadata().getParams());
        }
        catch (IOException e) {
            throw new FreeplayConfigurationException("Unable to read prompt template. ", e);
        }
    }
}

