/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin;

import ai.freeplay.client.thin.ChatMessage;
import ai.freeplay.client.thin.PromptInfo;
import java.util.List;
import java.util.stream.Collectors;

public class FormattedPrompt<LLMFormat> {
    private final PromptInfo promptInfo;
    private final LLMFormat formattedPrompt;

    public FormattedPrompt(PromptInfo promptInfo, LLMFormat formattedPrompt) {
        this.promptInfo = promptInfo;
        this.formattedPrompt = FormattedPrompt.isListOfThickMessages(formattedPrompt) ? FormattedPrompt.toThinChatMessages((List)formattedPrompt) : formattedPrompt;
    }

    public PromptInfo getPromptInfo() {
        return this.promptInfo;
    }

    public LLMFormat getFormattedPrompt() {
        return this.formattedPrompt;
    }

    private static <LLMFormat> boolean isListOfThickMessages(LLMFormat formattedPrompt) {
        return formattedPrompt instanceof List && !((List)formattedPrompt).isEmpty() && ((List)formattedPrompt).get(0) instanceof ai.freeplay.client.model.ChatMessage;
    }

    private static List<ChatMessage> toThinChatMessages(List<ai.freeplay.client.model.ChatMessage> modelMessages) {
        return modelMessages.stream().map(message -> new ChatMessage(message.getRole(), message.getContent())).collect(Collectors.toList());
    }
}

