/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin;

import ai.freeplay.client.HttpConfig;
import ai.freeplay.client.exceptions.FreeplayConfigurationException;
import ai.freeplay.client.flavor.ChatFlavor;
import ai.freeplay.client.flavor.Flavors;
import ai.freeplay.client.internal.JSONUtil;
import ai.freeplay.client.thin.APITemplateResolver;
import ai.freeplay.client.thin.BoundPrompt;
import ai.freeplay.client.thin.ChatMessage;
import ai.freeplay.client.thin.FormattedPrompt;
import ai.freeplay.client.thin.PromptInfo;
import ai.freeplay.client.thin.TemplatePrompt;
import ai.freeplay.client.thin.TemplateResolver;
import ai.freeplay.client.thin.ThinCallSupport;
import ai.freeplay.client.thin.internal.model.Template;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class Freeplay {
    private final ThinCallSupport callSupport;
    private final Prompts prompts;

    public Freeplay(FreeplayConfig config) {
        config.validate();
        this.callSupport = new ThinCallSupport(null, config.templateResolver);
        this.prompts = new Prompts();
    }

    public Prompts prompts() {
        return this.prompts;
    }

    public static FreeplayConfig Config() {
        return new FreeplayConfig();
    }

    public static class FreeplayConfig {
        private String freeplayAPIKey = null;
        private String baseUrl = null;
        private HttpConfig httpConfig = new HttpConfig();
        private TemplateResolver templateResolver = null;

        public FreeplayConfig freeplayAPIKey(String freeplayAPIKey) {
            this.freeplayAPIKey = freeplayAPIKey;
            return this;
        }

        public FreeplayConfig customerDomain(String domain) {
            return this.baseUrl(String.format("https://%s.freeplay.ai/api", domain));
        }

        public FreeplayConfig baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public FreeplayConfig httpConfig(HttpConfig httpConfig) {
            this.httpConfig = httpConfig;
            return this;
        }

        public FreeplayConfig templateResolver(TemplateResolver templateResolver) {
            this.templateResolver = templateResolver;
            return this;
        }

        public void validate() {
            if (this.templateResolver == null) {
                if (this.freeplayAPIKey == null || this.baseUrl == null) {
                    throw new FreeplayConfigurationException("Either a TemplateResolver must be configured, or the Freeplay API key and base URL must be configured.");
                }
                this.templateResolver = new APITemplateResolver(this.baseUrl, this.freeplayAPIKey, this.httpConfig);
            }
        }
    }

    public class Prompts {
        public CompletableFuture<TemplatePrompt> get(String projectId, String templateName, String environment) {
            return Freeplay.this.callSupport.getPrompt(projectId, templateName, environment).thenApply(template -> {
                this.validateReturnedTemplate((Template)template);
                ChatFlavor flavor = Flavors.getFlavorByName(template.getFlavorName());
                String model = template.getParams().get("model").toString();
                HashMap<String, Object> params = new HashMap<String, Object>(template.getParams());
                params.remove("model");
                List<ChatMessage> messages = JSONUtil.parseListOf(template.getContent(), ChatMessage.class);
                return new TemplatePrompt(new PromptInfo(template.getPromptTemplateId(), template.getPromptTemplateVersionId(), template.getName(), environment, params, flavor.getProvider(), model, template.getFlavorName()), messages);
            });
        }

        public <LLMFormat> CompletableFuture<FormattedPrompt<LLMFormat>> getFormatted(String projectId, String templateName, String environment, Map<String, Object> variables, String flavorName) {
            return this.getBound(projectId, templateName, environment, variables).thenApply(boundPrompt -> new FormattedPrompt(boundPrompt.getPromptInfo(), boundPrompt.format(flavorName)));
        }

        private CompletableFuture<BoundPrompt> getBound(String projectId, String templateName, String environment, Map<String, Object> variables) {
            return this.get(projectId, templateName, environment).thenApply(templatePrompt -> templatePrompt.bind(variables));
        }

        private void validateReturnedTemplate(Template template) {
            if (template.getFlavorName() == null) {
                throw new FreeplayConfigurationException("Flavor must be configured in the Freeplay UI. Unable to fulfill request.");
            }
            if (!template.getParams().containsKey("model")) {
                throw new FreeplayConfigurationException("Model must be configured in the Freeplay UI. Unable to fulfill request.");
            }
        }
    }
}

