/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin;

import ai.freeplay.client.HttpConfig;
import ai.freeplay.client.exceptions.FreeplayConfigurationException;
import ai.freeplay.client.exceptions.FreeplayException;
import ai.freeplay.client.internal.PromptUtils;
import ai.freeplay.client.thin.TemplateResolver;
import ai.freeplay.client.thin.internal.model.Template;
import ai.freeplay.client.thin.internal.model.Templates;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

class ThinCallSupport {
    private final HttpConfig httpConfig;
    private final TemplateResolver templateResolver;

    public ThinCallSupport(HttpConfig httpConfig, TemplateResolver templateResolver) {
        this.httpConfig = httpConfig;
        this.templateResolver = templateResolver;
    }

    public static String createSessionId() throws FreeplayException {
        return UUID.randomUUID().toString();
    }

    public static String getActiveFlavorName(String callFlavorName, String templateFlavorName) {
        return callFlavorName != null ? callFlavorName : templateFlavorName;
    }

    public CompletableFuture<Template> getPrompt(String projectId, String templateName, String environment) {
        return this.getPrompts(projectId, environment).thenApply(templates -> this.findPrompt((Templates)templates, templateName).orElseThrow(() -> new FreeplayConfigurationException(String.format("Could not find template %s in environment %s.%n", templateName, environment))));
    }

    private CompletableFuture<Templates> getPrompts(String projectId, String tag) {
        String finalTag = PromptUtils.getFinalTag(tag);
        return this.templateResolver.getPrompts(projectId, finalTag);
    }

    private Optional<Template> findPrompt(Templates templates, String templateName) {
        return templates.getTemplates().stream().filter(template -> template.getName().equals(templateName)).findFirst();
    }
}

