/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.internal;

import ai.freeplay.client.HttpConfig;
import ai.freeplay.client.exceptions.FreeplayException;
import ai.freeplay.client.internal.JSONUtil;
import ai.freeplay.client.internal.UserAgent;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncHttp {
    public static CompletableFuture<HttpResponse<String>> get(String url, String apiKey, HttpConfig httpConfig) throws FreeplayException {
        HttpRequest.Builder requestBuilder = AsyncHttp.request(url, apiKey, httpConfig);
        try {
            return AsyncHttp.client(httpConfig).build().sendAsync(requestBuilder.build(), HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception e) {
            throw new FreeplayException("Error sending GET request.", e);
        }
    }

    public static CompletableFuture<HttpResponse<String>> postJson(String url, String apiKey, HttpConfig httpConfig, Object body) throws FreeplayException {
        return AsyncHttp.sendJson(url, apiKey, httpConfig, "POST", body);
    }

    public static CompletableFuture<HttpResponse<String>> putJson(String url, String apiKey, HttpConfig httpConfig, Object body) throws FreeplayException {
        return AsyncHttp.sendJson(url, apiKey, httpConfig, "PUT", body);
    }

    private static CompletableFuture<HttpResponse<String>> sendJson(String url, String apiKey, HttpConfig httpConfig, String method, Object body) throws FreeplayException {
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofString(JSONUtil.toString(body));
        HttpRequest.Builder request = AsyncHttp.request(url, apiKey, httpConfig).method(method, bodyPublisher).header("Content-Type", "application/json");
        try {
            return AsyncHttp.client(httpConfig).build().sendAsync(request.build(), HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception e) {
            throw new FreeplayException(String.format("Error sending %s request.", method), e);
        }
    }

    private static HttpClient.Builder client(HttpConfig httpConfig) {
        HttpClient.Builder clientBuilder = HttpClient.newBuilder();
        if (httpConfig.getExecutor() != null) {
            clientBuilder.executor(httpConfig.getExecutor());
        }
        if (httpConfig.getProxySelector() != null) {
            clientBuilder.proxy(httpConfig.getProxySelector());
        }
        return clientBuilder;
    }

    private static HttpRequest.Builder request(String url, String apiKey, HttpConfig httpConfig) {
        HttpRequest.Builder requestBuilder;
        try {
            requestBuilder = HttpRequest.newBuilder(new URI(url)).header("User-Agent", UserAgent.getUserAgent());
            if (apiKey != null) {
                requestBuilder.header("Authorization", String.format("Bearer %s", apiKey));
            }
            if (httpConfig.getRequestTimeout() != null) {
                requestBuilder.timeout(httpConfig.getRequestTimeout());
            }
        }
        catch (URISyntaxException e) {
            throw new FreeplayException("Error in URL during GET request.", e);
        }
        return requestBuilder;
    }
}

