/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.processor;

import ai.freeplay.client.HttpConfig;
import ai.freeplay.client.exceptions.FreeplayException;
import ai.freeplay.client.exceptions.FreeplayServerException;
import ai.freeplay.client.internal.Http;
import ai.freeplay.client.model.PromptTemplate;
import ai.freeplay.client.processor.TemplateResolver;
import java.net.http.HttpResponse;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class APITemplateResolver
implements TemplateResolver {
    private final String baseUrl;
    private final String freeplayApiKey;
    private final HttpConfig httpConfig;

    public APITemplateResolver(String baseUrl, String freeplayApiKey, HttpConfig httpConfig) {
        this.baseUrl = baseUrl;
        this.freeplayApiKey = freeplayApiKey;
        this.httpConfig = httpConfig;
    }

    @Override
    public Collection<PromptTemplate> getPrompts(String projectId, String environment) {
        Map<String, Object> templatesMap;
        String url = String.format("%s/projects/%s/templates/all/%s", this.baseUrl, projectId, environment);
        HttpResponse<String> response = Http.get(url, this.freeplayApiKey, this.httpConfig);
        Http.throwFreeplayIfError(response, 200);
        try {
            templatesMap = Http.parseBody(response);
        }
        catch (FreeplayException e) {
            throw new FreeplayServerException("Error getting prompts.", e);
        }
        List templates = (List)templatesMap.get("templates");
        return templates.stream().map(template -> {
            Map templateMap = (Map)template;
            return new PromptTemplate(String.valueOf(templateMap.get("name")), String.valueOf(templateMap.get("content")), String.valueOf(templateMap.get("flavor_name")), String.valueOf(templateMap.get("project_version_id")), String.valueOf(templateMap.get("prompt_template_id")), String.valueOf(templateMap.get("prompt_template_version_id")), (Map)templateMap.get("params"));
        }).collect(Collectors.toList());
    }
}

