/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin;

import ai.freeplay.client.exceptions.FreeplayConfigurationException;
import ai.freeplay.client.thin.resources.prompts.ChatMessage;
import java.util.ArrayList;
import java.util.List;

public class LLMAdapters {
    public static LLMAdapter<?> adapterForFlavor(String flavor) {
        switch (flavor) {
            case "openai_chat": {
                return new OpenAILLMAdapter();
            }
            case "anthropic_chat": {
                return new AnthropicLLMAdapter();
            }
        }
        throw new FreeplayConfigurationException(String.format("Unable to create LLMAdapter for name '%s'.%n", flavor));
    }

    public static class OpenAILLMAdapter
    implements LLMAdapter<List<ChatMessage>> {
        @Override
        public List<ChatMessage> toLLMSyntax(List<ChatMessage> messages) {
            return messages;
        }
    }

    public static class AnthropicLLMAdapter
    implements LLMAdapter<String> {
        @Override
        public String toLLMSyntax(List<ChatMessage> messages) {
            ArrayList<Object> formattedMessages = new ArrayList<Object>();
            for (ChatMessage message : messages) {
                String content = message.getContent();
                String role = message.getRole().equals("assistant") ? "Assistant" : "Human";
                formattedMessages.add(role + ": " + content);
            }
            formattedMessages.add("Assistant:");
            return "\n\n" + String.join((CharSequence)"\n\n", formattedMessages);
        }
    }

    public static interface LLMAdapter<LLMFormat> {
        public LLMFormat toLLMSyntax(List<ChatMessage> var1);
    }
}

