/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin.resources.prompts;

import ai.freeplay.client.thin.LLMAdapters;
import ai.freeplay.client.thin.internal.ThinCallSupport;
import ai.freeplay.client.thin.resources.prompts.ChatMessage;
import ai.freeplay.client.thin.resources.prompts.FormattedPrompt;
import ai.freeplay.client.thin.resources.prompts.PromptInfo;
import java.util.List;

public class BoundPrompt {
    private final PromptInfo promptInfo;
    private final List<ChatMessage> messages;

    public BoundPrompt(PromptInfo promptInfo, List<ChatMessage> messages) {
        this.promptInfo = promptInfo;
        this.messages = messages;
    }

    public PromptInfo getPromptInfo() {
        return this.promptInfo;
    }

    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public <Format> FormattedPrompt<Format> format() {
        return this.format(null);
    }

    public <Format> FormattedPrompt<Format> format(String flavorName) {
        String finalFlavor = ThinCallSupport.getActiveFlavorName(flavorName, this.promptInfo.getFlavorName());
        LLMAdapters.LLMAdapter<?> llmAdapter = LLMAdapters.adapterForFlavor(finalFlavor);
        Object llmSyntax = llmAdapter.toLLMSyntax(this.messages);
        return new FormattedPrompt(this.getPromptInfo(), this.getMessages(), llmSyntax);
    }
}

