/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin;

import ai.freeplay.client.exceptions.FreeplayConfigurationException;
import ai.freeplay.client.internal.JSONUtil;
import ai.freeplay.client.thin.TemplateResolver;
import ai.freeplay.client.thin.internal.dto.LocalTemplateDTO;
import ai.freeplay.client.thin.internal.dto.TemplateDTO;
import ai.freeplay.client.thin.internal.dto.TemplatesDTO;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class FilesystemTemplateResolver
implements TemplateResolver {
    private final Path promptsDirectory;

    public FilesystemTemplateResolver(Path rootDirectory) {
        if (!Files.isDirectory(rootDirectory, new LinkOption[0])) {
            throw new FreeplayConfigurationException(String.format("Path for templates is not a directory. [%s]%n", rootDirectory.toAbsolutePath()));
        }
        this.promptsDirectory = rootDirectory.resolve("freeplay/prompts");
        if (!Files.isDirectory(this.promptsDirectory, new LinkOption[0])) {
            throw new FreeplayConfigurationException(String.format("Path for templates does not appear to be a Freeplay prompts directory. [%s]%n", rootDirectory.toAbsolutePath()));
        }
    }

    @Override
    public CompletableFuture<TemplatesDTO> getPrompts(String projectId, String environment) {
        Path environmentDir = this.promptsDirectory.resolve(projectId + "/" + environment);
        if (!Files.exists(environmentDir, new LinkOption[0])) {
            throw new FreeplayConfigurationException(String.format("Could not find directory for project %s and environment %s.%n", projectId, environment));
        }
        List<TemplateDTO> templateList = Arrays.stream(Objects.requireNonNull(environmentDir.toFile().listFiles((dir, name) -> name.endsWith(".json")))).map(this::toTemplate).collect(Collectors.toList());
        return CompletableFuture.completedFuture(new TemplatesDTO(templateList));
    }

    private TemplateDTO toTemplate(File templateFile) {
        File promptAbsoluteFile = templateFile.getAbsoluteFile();
        try {
            LocalTemplateDTO localTemplate = JSONUtil.parse(Files.readString(promptAbsoluteFile.toPath()), LocalTemplateDTO.class);
            return new TemplateDTO(localTemplate.getName(), localTemplate.getContent(), localTemplate.getMetadata().getFlavorName(), localTemplate.getPromptTemplateId(), localTemplate.getPromptTemplateVersionId(), localTemplate.getMetadata().getParams());
        }
        catch (IOException e) {
            throw new FreeplayConfigurationException("Unable to read prompt template. ", e);
        }
    }
}

