/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin;

import ai.freeplay.client.HttpConfig;
import ai.freeplay.client.exceptions.FreeplayConfigurationException;
import ai.freeplay.client.thin.APITemplateResolver;
import ai.freeplay.client.thin.TemplateResolver;
import ai.freeplay.client.thin.internal.ThinCallSupport;
import ai.freeplay.client.thin.resources.feedback.CustomerFeedback;
import ai.freeplay.client.thin.resources.prompts.Prompts;
import ai.freeplay.client.thin.resources.recordings.Recordings;
import ai.freeplay.client.thin.resources.sessions.Sessions;
import ai.freeplay.client.thin.resources.testruns.TestRuns;

public class Freeplay {
    private final Sessions sessions;
    private final Prompts prompts;
    private final Recordings recordings;
    private final TestRuns testRuns;
    private final CustomerFeedback customerFeedback;

    public Freeplay(FreeplayConfig config) {
        config.validate();
        ThinCallSupport callSupport = new ThinCallSupport(config.httpConfig, config.templateResolver, config.baseUrl, config.freeplayAPIKey);
        this.sessions = new Sessions();
        this.prompts = new Prompts(callSupport);
        this.recordings = new Recordings(callSupport);
        this.testRuns = new TestRuns(callSupport);
        this.customerFeedback = new CustomerFeedback(callSupport);
    }

    public Sessions sessions() {
        return this.sessions;
    }

    public Prompts prompts() {
        return this.prompts;
    }

    public Recordings recordings() {
        return this.recordings;
    }

    public TestRuns testRuns() {
        return this.testRuns;
    }

    public CustomerFeedback customerFeedback() {
        return this.customerFeedback;
    }

    public static FreeplayConfig Config() {
        return new FreeplayConfig();
    }

    public static class FreeplayConfig {
        private String freeplayAPIKey = null;
        private String baseUrl = null;
        private HttpConfig httpConfig = new HttpConfig();
        private TemplateResolver templateResolver = null;

        public FreeplayConfig freeplayAPIKey(String freeplayAPIKey) {
            this.freeplayAPIKey = freeplayAPIKey;
            return this;
        }

        public FreeplayConfig customerDomain(String domain) {
            return this.baseUrl(String.format("https://%s.freeplay.ai/api", domain));
        }

        public FreeplayConfig baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public FreeplayConfig httpConfig(HttpConfig httpConfig) {
            this.httpConfig = httpConfig;
            return this;
        }

        public FreeplayConfig templateResolver(TemplateResolver templateResolver) {
            this.templateResolver = templateResolver;
            return this;
        }

        public void validate() {
            if (this.templateResolver == null) {
                if (this.freeplayAPIKey == null || this.baseUrl == null) {
                    throw new FreeplayConfigurationException("Either a TemplateResolver must be configured, or the Freeplay API key and base URL must be configured.");
                }
                this.templateResolver = new APITemplateResolver(this.baseUrl, this.freeplayAPIKey, this.httpConfig);
            }
        }
    }
}

