/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin.internal;

import ai.freeplay.client.HttpConfig;
import ai.freeplay.client.exceptions.FreeplayClientException;
import ai.freeplay.client.exceptions.FreeplayConfigurationException;
import ai.freeplay.client.internal.AsyncHttp;
import ai.freeplay.client.internal.Http;
import ai.freeplay.client.internal.JSONUtil;
import ai.freeplay.client.internal.ParameterUtils;
import ai.freeplay.client.internal.PromptUtils;
import ai.freeplay.client.thin.TemplateResolver;
import ai.freeplay.client.thin.internal.dto.RecordDTO;
import ai.freeplay.client.thin.internal.dto.TemplateDTO;
import ai.freeplay.client.thin.internal.dto.TemplatesDTO;
import ai.freeplay.client.thin.internal.dto.TestListDTO;
import ai.freeplay.client.thin.internal.dto.TestRunDTO;
import ai.freeplay.client.thin.resources.feedback.CustomerFeedbackResponse;
import ai.freeplay.client.thin.resources.prompts.ChatMessage;
import ai.freeplay.client.thin.resources.recordings.RecordInfo;
import ai.freeplay.client.thin.resources.recordings.RecordResponse;
import ai.freeplay.client.thin.resources.testruns.TestCase;
import ai.freeplay.client.thin.resources.testruns.TestRun;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class ThinCallSupport {
    private final HttpConfig httpConfig;
    private final TemplateResolver templateResolver;
    private final String baseUrl;
    private final String freeplayApiKey;

    public ThinCallSupport(HttpConfig httpConfig, TemplateResolver templateResolver, String baseUrl, String freeplayApiKey) {
        this.httpConfig = httpConfig;
        this.templateResolver = templateResolver;
        this.baseUrl = baseUrl;
        this.freeplayApiKey = freeplayApiKey;
    }

    public static String getActiveFlavorName(String callFlavorName, String templateFlavorName) {
        return callFlavorName != null ? callFlavorName : templateFlavorName;
    }

    public CompletableFuture<TemplateDTO> getPrompt(String projectId, String templateName, String environment) {
        return this.getPrompts(projectId, environment).thenApply(templates -> this.findPrompt((TemplatesDTO)templates, templateName).orElseThrow(() -> new FreeplayConfigurationException(String.format("Could not find template %s in project %s in environment %s.%n", projectId, templateName, environment))));
    }

    public CompletableFuture<RecordResponse> record(RecordInfo recordPayload) {
        if (recordPayload.getAllMessages().isEmpty()) {
            throw new FreeplayClientException("Messages list must have at least one message. The last message should be the current response.");
        }
        String historyAsString = ThinCallSupport.historyAsString(recordPayload.getAllMessages());
        ChatMessage completion = recordPayload.getAllMessages().get(recordPayload.getAllMessages().size() - 1);
        String testRunId = recordPayload.getTestRunInfo() == null ? null : recordPayload.getTestRunInfo().getTestRunId();
        String testCaseId = recordPayload.getTestRunInfo() == null ? null : recordPayload.getTestRunInfo().getTestCaseId();
        RecordDTO payload = new RecordDTO(recordPayload.getSessionInfo().getSessionId(), recordPayload.getPromptInfo().getPromptTemplateVersionId(), recordPayload.getPromptInfo().getPromptTemplateId(), recordPayload.getCallInfo().getStartTime(), recordPayload.getCallInfo().getEndTime(), recordPayload.getPromptInfo().getEnvironment(), recordPayload.getInputs(), recordPayload.getSessionInfo().getCustomMetadata(), historyAsString, completion.getContent(), recordPayload.getResponseInfo().isComplete(), testRunId, testCaseId, recordPayload.getCallInfo().getProvider(), recordPayload.getCallInfo().getModel(), recordPayload.getCallInfo().getModelParameters(), recordPayload.getResponseInfo().getFunctionCallMap());
        return AsyncHttp.postJson(String.format("%s/v1/record", this.baseUrl), this.freeplayApiKey, this.httpConfig, payload).thenApply(httpResponse -> {
            Http.throwFreeplayIfError(httpResponse, 201);
            JsonNode responseNode = JSONUtil.parseDOM((String)httpResponse.body());
            return new RecordResponse(responseNode.path("completion_id").asText(null));
        });
    }

    public CompletableFuture<TestRun> createTestRun(String projectId, String testList, boolean includeOutputs) {
        String url = String.format("%s/projects/%s/test-runs-cases", this.baseUrl, projectId);
        return AsyncHttp.postJson(url, this.freeplayApiKey, this.httpConfig, new TestListDTO(testList, includeOutputs)).thenApply(httpResponse -> {
            Http.throwFreeplayIfError(httpResponse, 201);
            TestRunDTO testRun = JSONUtil.parse((String)httpResponse.body(), TestRunDTO.class);
            return new TestRun(testRun.getTestRunId(), testRun.getTestCases().stream().map(testCase -> new TestCase(testCase.getId(), testCase.getVariables(), testCase.getOutput())).collect(Collectors.toList()));
        });
    }

    public CompletableFuture<CustomerFeedbackResponse> updateCustomerFeedback(String completionId, Map<String, Object> feedback) {
        ParameterUtils.validateBasicMap(feedback);
        String url = String.format("%s/v1/completion_feedback/%s", this.baseUrl, completionId);
        return AsyncHttp.putJson(url, this.freeplayApiKey, this.httpConfig, feedback).thenApply(httpResponse -> {
            Http.throwFreeplayIfError(httpResponse, 201);
            return new CustomerFeedbackResponse();
        });
    }

    private static String historyAsString(List<ChatMessage> allMessages) {
        List<ChatMessage> allButLast = allMessages.subList(0, allMessages.size() - 1);
        return JSONUtil.toString(allButLast);
    }

    private CompletableFuture<TemplatesDTO> getPrompts(String projectId, String tag) {
        String finalTag = PromptUtils.getFinalTag(tag);
        return this.templateResolver.getPrompts(projectId, finalTag);
    }

    private Optional<TemplateDTO> findPrompt(TemplatesDTO templates, String templateName) {
        return templates.getTemplates().stream().filter(template -> template.getName().equals(templateName)).findFirst();
    }
}

