/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin;

import ai.freeplay.client.HttpConfig;
import ai.freeplay.client.internal.AsyncHttp;
import ai.freeplay.client.internal.Http;
import ai.freeplay.client.internal.JSONUtil;
import ai.freeplay.client.thin.TemplateResolver;
import ai.freeplay.client.thin.internal.v2dto.TemplateDTO;
import ai.freeplay.client.thin.internal.v2dto.TemplatesDTO;
import java.util.concurrent.CompletableFuture;

public class APITemplateResolver
implements TemplateResolver {
    private final String baseUrl;
    private final String freeplayApiKey;
    private final HttpConfig httpConfig;

    public APITemplateResolver(String baseUrl, String freeplayApiKey, HttpConfig httpConfig) {
        this.baseUrl = baseUrl;
        this.freeplayApiKey = freeplayApiKey;
        this.httpConfig = httpConfig;
    }

    @Override
    public CompletableFuture<TemplatesDTO> getPrompts(String projectId, String environment) {
        String url = String.format("%s/v2/projects/%s/prompt-templates/all/%s", this.baseUrl, projectId, environment);
        return AsyncHttp.get(url, this.freeplayApiKey, this.httpConfig).thenApply(response -> {
            Http.throwFreeplayIfError(response, 200);
            return JSONUtil.parse((String)response.body(), TemplatesDTO.class);
        });
    }

    @Override
    public CompletableFuture<TemplateDTO> getPrompt(String projectId, String templateName, String environment) {
        String url = String.format("%s/v2/projects/%s/prompt-templates/name/%s?environment=%s", this.baseUrl, projectId, templateName, environment);
        return AsyncHttp.get(url, this.freeplayApiKey, this.httpConfig).thenApply(response -> {
            Http.throwFreeplayIfError(response, 200);
            return JSONUtil.parse((String)response.body(), TemplateDTO.class);
        });
    }
}

