/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin;

import ai.freeplay.client.exceptions.FreeplayConfigurationException;
import ai.freeplay.client.thin.resources.prompts.ChatMessage;
import java.util.List;
import java.util.stream.Collectors;

public class LLMAdapters {
    public static LLMAdapter<?> adapterForFlavor(String flavor) {
        switch (flavor) {
            case "openai_chat": {
                return new OpenAILLMAdapter();
            }
            case "anthropic_chat": {
                return new AnthropicLLMAdapter();
            }
        }
        throw new FreeplayConfigurationException(String.format("Unable to create LLMAdapter for name '%s'.%n", flavor));
    }

    public static class OpenAILLMAdapter
    implements LLMAdapter<List<ChatMessage>> {
        @Override
        public String getProvider() {
            return "openai";
        }

        @Override
        public List<ChatMessage> toLLMSyntax(List<ChatMessage> messages) {
            return messages;
        }
    }

    public static class AnthropicLLMAdapter
    implements LLMAdapter<List<ChatMessage>> {
        @Override
        public String getProvider() {
            return "anthropic";
        }

        @Override
        public List<ChatMessage> toLLMSyntax(List<ChatMessage> messages) {
            return messages.stream().filter(message -> !message.getRole().equals("system")).collect(Collectors.toList());
        }
    }

    public static interface LLMAdapter<LLMFormat> {
        public String getProvider();

        public LLMFormat toLLMSyntax(List<ChatMessage> var1);
    }
}

