/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin.internal.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.util.Map;
import java.util.Objects;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class RecordDTO {
    private String sessionId;
    private String projectVersionId;
    private String promptTemplateId;
    private double startTime;
    private double endTime;
    private String tag;
    private Map<String, Object> inputs;
    private Map<String, Object> customMetadata;
    private String promptContent;
    private String returnContent;
    private String testRunId;
    private String testCaseId;
    private String provider;
    private String model;
    private Map<String, Object> llmParameters;
    private Map<String, Object> providerInfo;
    private boolean isComplete;
    private Map<String, String> functionCallResponse;

    public RecordDTO() {
    }

    public RecordDTO(String sessionId, String projectVersionId, String promptTemplateId, double startTime, double endTime, String tag, Map<String, Object> inputs, Map<String, Object> customMetadata, String promptContent, String returnContent, boolean isComplete, String testRunId, String testCaseId, String provider, String model, Map<String, Object> llmParameters, Map<String, Object> providerInfo, Map<String, String> functionCallResponse) {
        this.sessionId = sessionId;
        this.projectVersionId = projectVersionId;
        this.promptTemplateId = promptTemplateId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.tag = tag;
        this.inputs = inputs;
        this.customMetadata = customMetadata;
        this.promptContent = promptContent;
        this.returnContent = returnContent;
        this.isComplete = isComplete;
        this.testRunId = testRunId;
        this.testCaseId = testCaseId;
        this.provider = provider;
        this.model = model;
        this.llmParameters = llmParameters;
        this.providerInfo = providerInfo;
        this.functionCallResponse = functionCallResponse;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getProjectVersionId() {
        return this.projectVersionId;
    }

    public String getPromptTemplateId() {
        return this.promptTemplateId;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public String getTag() {
        return this.tag;
    }

    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    public Map<String, Object> getCustomMetadata() {
        return this.customMetadata;
    }

    public String getPromptContent() {
        return this.promptContent;
    }

    public String getReturnContent() {
        return this.returnContent;
    }

    @JsonProperty(value="is_complete")
    public boolean isComplete() {
        return this.isComplete;
    }

    public void setIsComplete(boolean isComplete) {
        this.isComplete = isComplete;
    }

    public String getTestRunId() {
        return this.testRunId;
    }

    public String getTestCaseId() {
        return this.testCaseId;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getModel() {
        return this.model;
    }

    public Map<String, Object> getLlmParameters() {
        return this.llmParameters;
    }

    public Map<String, Object> getProviderInfo() {
        return this.providerInfo;
    }

    public Map<String, String> getFunctionCallResponse() {
        return this.functionCallResponse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordDTO recordDTO = (RecordDTO)o;
        return Double.compare(recordDTO.startTime, this.startTime) == 0 && Double.compare(recordDTO.endTime, this.endTime) == 0 && this.isComplete == recordDTO.isComplete && Objects.equals(this.sessionId, recordDTO.sessionId) && Objects.equals(this.projectVersionId, recordDTO.projectVersionId) && Objects.equals(this.promptTemplateId, recordDTO.promptTemplateId) && Objects.equals(this.tag, recordDTO.tag) && Objects.equals(this.inputs, recordDTO.inputs) && Objects.equals(this.customMetadata, recordDTO.customMetadata) && Objects.equals(this.promptContent, recordDTO.promptContent) && Objects.equals(this.returnContent, recordDTO.returnContent) && Objects.equals(this.testRunId, recordDTO.testRunId) && Objects.equals(this.testCaseId, recordDTO.testCaseId) && Objects.equals(this.provider, recordDTO.provider) && Objects.equals(this.model, recordDTO.model) && Objects.equals(this.llmParameters, recordDTO.llmParameters) && Objects.equals(this.providerInfo, recordDTO.providerInfo) && Objects.equals(this.functionCallResponse, recordDTO.functionCallResponse);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.projectVersionId, this.promptTemplateId, this.startTime, this.endTime, this.tag, this.inputs, this.customMetadata, this.promptContent, this.returnContent, this.testRunId, this.testCaseId, this.provider, this.model, this.llmParameters, this.providerInfo, this.isComplete, this.functionCallResponse);
    }

    public String toString() {
        return "RecordDTO{sessionId='" + this.sessionId + "', projectVersionId='" + this.projectVersionId + "', promptTemplateId='" + this.promptTemplateId + "', startTime=" + this.startTime + ", endTime=" + this.endTime + ", tag='" + this.tag + "', inputs=" + this.inputs + ", customMetadata=" + this.customMetadata + ", promptContent='" + this.promptContent + "', returnContent='" + this.returnContent + "', testRunId='" + this.testRunId + "', testCaseId='" + this.testCaseId + "', provider='" + this.provider + "', model='" + this.model + "', llmParameters=" + this.llmParameters + ", providerInfo=" + this.providerInfo + ", isComplete=" + this.isComplete + ", functionCallResponse=" + this.functionCallResponse + "}";
    }
}

