/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin;

import ai.freeplay.client.exceptions.FreeplayConfigurationException;
import ai.freeplay.client.thin.resources.prompts.ChatMessage;
import java.util.List;
import java.util.stream.Collectors;

public class LLMAdapters {
    public static LLMAdapter<?> adapterForFlavor(String flavor) {
        switch (flavor) {
            case "openai_chat": {
                return new OpenAILLMAdapter();
            }
            case "anthropic_chat": {
                return new AnthropicLLMAdapter();
            }
            case "llama_3_chat": {
                return new Llama3LLMAdapter();
            }
            case "baseten_mistral_chat": {
                return new BasetenLLMAdapter();
            }
        }
        throw new FreeplayConfigurationException(String.format("Unable to create LLMAdapter for name '%s'.%n", flavor));
    }

    public static class BasetenLLMAdapter
    implements LLMAdapter<List<ChatMessage>> {
        @Override
        public String getProvider() {
            return "baseten";
        }

        @Override
        public List<ChatMessage> toLLMSyntax(List<ChatMessage> messages) {
            return messages;
        }
    }

    public static class OpenAILLMAdapter
    implements LLMAdapter<List<ChatMessage>> {
        @Override
        public String getProvider() {
            return "openai";
        }

        @Override
        public List<ChatMessage> toLLMSyntax(List<ChatMessage> messages) {
            return messages;
        }
    }

    public static class Llama3LLMAdapter
    implements LLMAdapter<String> {
        @Override
        public String getProvider() {
            return "sagemaker";
        }

        @Override
        public String toLLMSyntax(List<ChatMessage> messages) {
            return "<|begin_of_text|>" + messages.stream().map(message -> String.format("<|start_header_id|>%s<|end_header_id|>\n%s<|eot_id|>", message.getRole(), message.getContent())).collect(Collectors.joining("")) + "<|start_header_id|>assistant<|end_header_id|>";
        }
    }

    public static class GeminiLLMAdapter
    implements LLMAdapter<List<ChatMessage>> {
        @Override
        public String getProvider() {
            return "vertex";
        }

        @Override
        public List<ChatMessage> toLLMSyntax(List<ChatMessage> messages) {
            return messages.stream().filter(message -> !message.getRole().equals("system")).map(message -> new ChatMessage(this.translateRole(message.getRole()), message.getContent())).collect(Collectors.toList());
        }

        private String translateRole(String role) {
            switch (role) {
                case "user": {
                    return "user";
                }
                case "assistant": {
                    return "model";
                }
            }
            throw new FreeplayConfigurationException(String.format("Unknown role in prompt template for Gemini: %s", role));
        }
    }

    public static class AnthropicLLMAdapter
    implements LLMAdapter<List<ChatMessage>> {
        @Override
        public String getProvider() {
            return "anthropic";
        }

        @Override
        public List<ChatMessage> toLLMSyntax(List<ChatMessage> messages) {
            return messages.stream().filter(message -> !message.getRole().equals("system")).collect(Collectors.toList());
        }
    }

    public static interface LLMAdapter<LLMFormat> {
        public String getProvider();

        public LLMFormat toLLMSyntax(List<ChatMessage> var1);
    }
}

