/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin.internal;

import ai.freeplay.client.HttpConfig;
import ai.freeplay.client.exceptions.FreeplayClientException;
import ai.freeplay.client.internal.AsyncHttp;
import ai.freeplay.client.internal.Http;
import ai.freeplay.client.internal.JSONUtil;
import ai.freeplay.client.internal.ParameterUtils;
import ai.freeplay.client.internal.PromptUtils;
import ai.freeplay.client.thin.TemplateResolver;
import ai.freeplay.client.thin.internal.dto.RecordDTO;
import ai.freeplay.client.thin.internal.dto.TestListDTO;
import ai.freeplay.client.thin.internal.dto.TestRunDTO;
import ai.freeplay.client.thin.internal.dto.TestRunResultsDTO;
import ai.freeplay.client.thin.internal.v2dto.TemplateDTO;
import ai.freeplay.client.thin.resources.feedback.CustomerFeedbackResponse;
import ai.freeplay.client.thin.resources.prompts.ChatMessage;
import ai.freeplay.client.thin.resources.recordings.RecordInfo;
import ai.freeplay.client.thin.resources.recordings.RecordResponse;
import ai.freeplay.client.thin.resources.sessions.SessionDeleteResponse;
import ai.freeplay.client.thin.resources.testruns.TestCase;
import ai.freeplay.client.thin.resources.testruns.TestRun;
import ai.freeplay.client.thin.resources.testruns.TestRunResults;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class ThinCallSupport {
    private final HttpConfig httpConfig;
    private final TemplateResolver templateResolver;
    private final String baseUrl;
    private final String freeplayApiKey;

    public ThinCallSupport(HttpConfig httpConfig, TemplateResolver templateResolver, String baseUrl, String freeplayApiKey) {
        this.httpConfig = httpConfig;
        this.templateResolver = templateResolver;
        this.baseUrl = baseUrl;
        this.freeplayApiKey = freeplayApiKey;
    }

    public static String getActiveFlavorName(String callFlavorName, String templateFlavorName) {
        return callFlavorName != null ? callFlavorName : templateFlavorName;
    }

    public CompletableFuture<TemplateDTO> getPrompt(String projectId, String templateName, String environment) {
        return this.templateResolver.getPrompt(projectId, templateName, PromptUtils.getFinalEnvironment(environment));
    }

    public CompletableFuture<TemplateDTO> getPromptByVersionId(String projectId, String templateId, String templateVersionId) {
        return this.templateResolver.getPromptByVersionId(projectId, templateId, templateVersionId);
    }

    public CompletableFuture<RecordResponse> record(RecordInfo recordPayload) {
        if (recordPayload.getAllMessages().isEmpty()) {
            throw new FreeplayClientException("Messages list must have at least one message. The last message should be the current response.");
        }
        String testRunId = recordPayload.getTestRunInfo() == null ? null : recordPayload.getTestRunInfo().getTestRunId();
        String testCaseId = recordPayload.getTestRunInfo() == null ? null : recordPayload.getTestRunInfo().getTestCaseId();
        RecordDTO.ResponseInfoDTO responseInfo = new RecordDTO.ResponseInfoDTO(recordPayload.getResponseInfo().isComplete(), recordPayload.getResponseInfo().getFunctionCall() != null ? new RecordDTO.OpenAIFunctionCallDTO(recordPayload.getResponseInfo().getFunctionCall().getName(), recordPayload.getResponseInfo().getFunctionCall().getArguments()) : null, recordPayload.getResponseInfo().getPromptTokens(), recordPayload.getResponseInfo().getResponseTokens());
        RecordDTO payload = new RecordDTO(recordPayload.getAllMessages(), recordPayload.getInputs(), new RecordDTO.SessionInfoDTO(recordPayload.getSessionInfo().getSessionId(), recordPayload.getSessionInfo().getCustomMetadata()), new RecordDTO.PromptInfoDTO(recordPayload.getPromptInfo().getPromptTemplateId(), recordPayload.getPromptInfo().getPromptTemplateVersionId(), recordPayload.getPromptInfo().getTemplateName(), recordPayload.getPromptInfo().getEnvironment(), recordPayload.getPromptInfo().getModelParameters(), recordPayload.getPromptInfo().getProviderInfo(), recordPayload.getPromptInfo().getProvider(), recordPayload.getPromptInfo().getModel(), recordPayload.getPromptInfo().getFlavorName(), recordPayload.getPromptInfo().getProjectId()), new RecordDTO.CallInfoDTO(recordPayload.getCallInfo().getProvider(), recordPayload.getCallInfo().getModel(), (long)recordPayload.getCallInfo().getStartTime(), (long)recordPayload.getCallInfo().getEndTime(), recordPayload.getCallInfo().getProviderInfo()), responseInfo, testRunId != null ? new RecordDTO.TestRunInfoDTO(testRunId, testCaseId) : null, recordPayload.getEvalResults());
        return AsyncHttp.postJson(String.format("%s/v2/projects/%s/sessions/%s/completions", this.baseUrl, recordPayload.getPromptInfo().getProjectId(), recordPayload.getSessionInfo().getSessionId()), this.freeplayApiKey, this.httpConfig, payload).thenApply(httpResponse -> {
            Http.throwFreeplayIfError(httpResponse, 201);
            JsonNode responseNode = JSONUtil.parseDOM((String)httpResponse.body());
            return new RecordResponse(responseNode.path("completion_id").asText(null));
        });
    }

    public CompletableFuture<TestRun> createTestRun(String projectId, String testList, boolean includeOutputs, String name, String description) {
        String url = String.format("%s/v2/projects/%s/test-runs", this.baseUrl, projectId);
        return AsyncHttp.postJson(url, this.freeplayApiKey, this.httpConfig, new TestListDTO(testList, includeOutputs, name, description)).thenApply(httpResponse -> {
            Http.throwFreeplayIfError(httpResponse, 201);
            TestRunDTO testRun = JSONUtil.parse((String)httpResponse.body(), TestRunDTO.class);
            return new TestRun(testRun.getTestRunId(), testRun.getTestCases().stream().map(testCase -> new TestCase(testCase.getTestCaseId(), testCase.getVariables(), testCase.getOutput())).collect(Collectors.toList()));
        });
    }

    public CompletableFuture<TestRunResults> getTestRunResults(String projectId, String testRunId) {
        String url = String.format("%s/v2/projects/%s/test-runs/id/%s", this.baseUrl, projectId, testRunId);
        return AsyncHttp.get(url, this.freeplayApiKey, this.httpConfig).thenApply(httpResponse -> {
            Http.throwFreeplayIfError(httpResponse, 200);
            TestRunResultsDTO testRunResults = JSONUtil.parse((String)httpResponse.body(), TestRunResultsDTO.class);
            return new TestRunResults(testRunResults.getId(), testRunResults.getName(), testRunResults.getDescription(), testRunResults.getSummaryStatistics());
        });
    }

    public CompletableFuture<CustomerFeedbackResponse> updateCustomerFeedback(String completionId, Map<String, Object> feedback) {
        ParameterUtils.validateBasicMap(feedback);
        String url = String.format("%s/v1/completion_feedback/%s", this.baseUrl, completionId);
        return AsyncHttp.putJson(url, this.freeplayApiKey, this.httpConfig, feedback).thenApply(httpResponse -> {
            Http.throwFreeplayIfError(httpResponse, 201);
            return new CustomerFeedbackResponse();
        });
    }

    public CompletableFuture<SessionDeleteResponse> deleteSession(String projectId, String sessionId) {
        String url = String.format("%s/v2/projects/%s/sessions/%s", this.baseUrl, projectId, sessionId);
        return AsyncHttp.delete(url, this.freeplayApiKey, this.httpConfig).thenApply(httpResponse -> {
            Http.throwFreeplayIfError(httpResponse, 201);
            return new SessionDeleteResponse();
        });
    }

    private static String historyAsString(List<ChatMessage> allMessages) {
        List<ChatMessage> allButLast = allMessages.subList(0, allMessages.size() - 1);
        return JSONUtil.toString(allButLast);
    }
}

