/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin.internal.v2dto;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class TemplateDTO {
    private String promptTemplateId;
    private String promptTemplateVersionId;
    private String promptTemplateName;
    private List<Message> content;
    private Metadata metadata;
    private int formatVersion = -1;
    private String projectId;

    public TemplateDTO() {
    }

    public TemplateDTO(String promptTemplateId, String promptTemplateVersionId, String promptTemplateName, List<Message> content, Metadata metadata, int formatVersion, String projectId) {
        this.promptTemplateId = promptTemplateId;
        this.promptTemplateVersionId = promptTemplateVersionId;
        this.promptTemplateName = promptTemplateName;
        this.content = content;
        this.metadata = metadata;
        this.formatVersion = formatVersion;
        this.projectId = projectId;
    }

    public String getPromptTemplateId() {
        return this.promptTemplateId;
    }

    public String getPromptTemplateVersionId() {
        return this.promptTemplateVersionId;
    }

    public String getPromptTemplateName() {
        return this.promptTemplateName;
    }

    public List<Message> getContent() {
        return this.content;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public int getFormatVersion() {
        return this.formatVersion;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateDTO that = (TemplateDTO)o;
        return this.formatVersion == that.formatVersion && Objects.equals(this.promptTemplateId, that.promptTemplateId) && Objects.equals(this.promptTemplateVersionId, that.promptTemplateVersionId) && Objects.equals(this.promptTemplateName, that.promptTemplateName) && Objects.equals(this.content, that.content) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.promptTemplateId, this.promptTemplateVersionId, this.promptTemplateName, this.content, this.metadata, this.formatVersion, this.projectId);
    }

    public String toString() {
        return "TemplateDTO{promptTemplateId='" + this.promptTemplateId + "', promptTemplateVersionId='" + this.promptTemplateVersionId + "', promptTemplateName='" + this.promptTemplateName + "', content=" + this.content + ", metadata=" + this.metadata + ", formatVersion=" + this.formatVersion + ", projectId='" + this.projectId + "'}";
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class Message {
        private String role;
        private String content;

        public Message() {
        }

        public Message(String role, String content) {
            this.role = role;
            this.content = content;
        }

        public String getRole() {
            return this.role;
        }

        public String getContent() {
            return this.content;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Message message = (Message)o;
            return Objects.equals(this.role, message.role) && Objects.equals(this.content, message.content);
        }

        public int hashCode() {
            return Objects.hash(this.role, this.content);
        }

        public String toString() {
            return "Message{role='" + this.role + "', content='" + this.content + "'}";
        }
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class Metadata {
        private String provider;
        private String model;
        private String flavor;
        private Map<String, Object> params;
        private Map<String, Object> providerInfo;

        public Metadata() {
        }

        public Metadata(String provider, String model, String flavor, Map<String, Object> params, Map<String, Object> providerInfo) {
            this.provider = provider;
            this.model = model;
            this.flavor = flavor;
            this.params = params;
            this.providerInfo = providerInfo;
        }

        public String getProvider() {
            return this.provider;
        }

        public String getModel() {
            return this.model;
        }

        public String getFlavor() {
            return this.flavor;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public Map<String, Object> getProviderInfo() {
            return this.providerInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Metadata metadata = (Metadata)o;
            return Objects.equals(this.provider, metadata.provider) && Objects.equals(this.model, metadata.model) && Objects.equals(this.flavor, metadata.flavor) && Objects.equals(this.params, metadata.params) && Objects.equals(this.providerInfo, metadata.providerInfo);
        }

        public int hashCode() {
            return Objects.hash(this.provider, this.model, this.flavor, this.params, this.providerInfo);
        }

        public String toString() {
            return "Metadata{provider='" + this.provider + "', model='" + this.model + "', flavor='" + this.flavor + "', params=" + this.params + ", providerInfo=" + this.providerInfo + "}";
        }
    }
}

