/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin.resources.prompts;

import ai.freeplay.client.exceptions.FreeplayConfigurationException;
import ai.freeplay.client.thin.LLMAdapters;
import ai.freeplay.client.thin.internal.ThinCallSupport;
import ai.freeplay.client.thin.internal.v2dto.TemplateDTO;
import ai.freeplay.client.thin.resources.prompts.BoundPrompt;
import ai.freeplay.client.thin.resources.prompts.ChatMessage;
import ai.freeplay.client.thin.resources.prompts.FormattedPrompt;
import ai.freeplay.client.thin.resources.prompts.PromptInfo;
import ai.freeplay.client.thin.resources.prompts.TemplatePrompt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class Prompts {
    private final ThinCallSupport callSupport;

    public Prompts(ThinCallSupport callSupport) {
        this.callSupport = callSupport;
    }

    public CompletableFuture<TemplatePrompt> get(String projectId, String templateName, String environment) {
        return this.callSupport.getPrompt(projectId, templateName, environment).thenApply(template -> this.getTemplateFromDTO(projectId, environment, (TemplateDTO)template));
    }

    public CompletableFuture<TemplatePrompt> getByVersionId(String projectId, String templateId, String templateVersionId) {
        return this.callSupport.getPromptByVersionId(projectId, templateId, templateVersionId).thenApply(template -> this.getTemplateFromDTO(projectId, null, (TemplateDTO)template));
    }

    public <LLMFormat> CompletableFuture<FormattedPrompt<LLMFormat>> getFormatted(String projectId, String templateName, String environment, Map<String, Object> variables, String flavorName) {
        return this.getBound(projectId, templateName, environment, variables).thenApply(boundPrompt -> boundPrompt.format(flavorName));
    }

    public <LLMFormat> CompletableFuture<FormattedPrompt<LLMFormat>> getFormatted(String projectId, String templateName, String environment, Map<String, Object> variables) {
        return this.getBound(projectId, templateName, environment, variables).thenApply(BoundPrompt::format);
    }

    public <LLMFormat> CompletableFuture<FormattedPrompt<LLMFormat>> getFormattedByVersionId(String projectId, String templateId, String templateVersionId, Map<String, Object> variables, String flavorName) {
        return ((CompletableFuture)this.getByVersionId(projectId, templateId, templateVersionId).thenApply(templatePrompt -> templatePrompt.bind(variables))).thenApply(boundPrompt -> boundPrompt.format(flavorName));
    }

    private CompletableFuture<BoundPrompt> getBound(String projectId, String templateName, String environment, Map<String, Object> variables) {
        return this.get(projectId, templateName, environment).thenApply(templatePrompt -> templatePrompt.bind(variables));
    }

    private void validateReturnedTemplate(TemplateDTO template) {
        if (template.getMetadata().getFlavor() == null) {
            throw new FreeplayConfigurationException("Flavor must be configured in the Freeplay UI. Unable to fulfill request.");
        }
        if (template.getMetadata().getModel() == null) {
            throw new FreeplayConfigurationException("Model must be configured in the Freeplay UI. Unable to fulfill request.");
        }
    }

    private TemplatePrompt getTemplateFromDTO(String projectId, String environment, TemplateDTO template) {
        this.validateReturnedTemplate(template);
        LLMAdapters.LLMAdapter<?> llmAdapter = LLMAdapters.adapterForFlavor(template.getMetadata().getFlavor());
        String model = template.getMetadata().getModel();
        HashMap<String, Object> params = new HashMap<String, Object>(template.getMetadata().getParams());
        params.remove("model");
        List<ChatMessage> messages = template.getContent().stream().map(message -> new ChatMessage(message.getRole(), message.getContent())).collect(Collectors.toList());
        PromptInfo promptInfo = new PromptInfo(template.getPromptTemplateId(), template.getPromptTemplateVersionId(), template.getPromptTemplateName(), environment, params, llmAdapter.getProvider(), model, template.getMetadata().getFlavor(), projectId).providerInfo(template.getMetadata().getProviderInfo());
        return new TemplatePrompt(promptInfo, messages);
    }
}

