/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin.resources.prompts;

import ai.freeplay.client.Freeplay;
import ai.freeplay.client.exceptions.FreeplayClientException;
import ai.freeplay.client.internal.TemplateUtils;
import ai.freeplay.client.thin.resources.prompts.BoundPrompt;
import ai.freeplay.client.thin.resources.prompts.ChatMessage;
import ai.freeplay.client.thin.resources.prompts.KindMessage;
import ai.freeplay.client.thin.resources.prompts.PromptInfo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TemplatePrompt {
    public static final System.Logger LOGGER = System.getLogger(Freeplay.class.getName());
    private final PromptInfo promptInfo;
    private final List<ChatMessage> messages;

    public TemplatePrompt(PromptInfo promptInfo, List<ChatMessage> messages) {
        this.promptInfo = promptInfo;
        this.messages = messages;
    }

    public PromptInfo getPromptInfo() {
        return this.promptInfo;
    }

    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public BoundPrompt bind(Map<String, Object> variables) {
        return this.bind(variables, null);
    }

    public BoundPrompt bind(Map<String, Object> variables, List<ChatMessage> history) {
        if (!this.hasHistoryPlaceholder() && history != null) {
            throw new FreeplayClientException(String.format("Received history but prompt '%s' does not have a history placeholder.", this.promptInfo.getTemplateName()));
        }
        if (this.hasHistoryPlaceholder() && history == null) {
            LOGGER.log(System.Logger.Level.WARNING, "Prompt '{0}' has a history placeholder but no history was provided.", this.promptInfo.getTemplateName());
        }
        List<ChatMessage> messages = this.getMessages().stream().flatMap(chatMessage -> {
            if (chatMessage.isKind()) {
                if (history != null) {
                    return history.stream();
                }
                return Stream.of(new ChatMessage[0]);
            }
            return Stream.of(new ChatMessage(chatMessage.getRole(), TemplateUtils.format(chatMessage.getContent(), variables)));
        }).collect(Collectors.toList());
        return new BoundPrompt(this.promptInfo, messages);
    }

    private boolean hasHistoryPlaceholder() {
        return this.messages.stream().anyMatch(message -> message.isKind() && ((KindMessage)message).getValue().equals("history"));
    }
}

