/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin.resources.sessions;

import ai.freeplay.client.internal.ParameterUtils;
import ai.freeplay.client.thin.internal.ThinCallSupport;
import ai.freeplay.client.thin.resources.sessions.SessionInfo;
import ai.freeplay.client.thin.resources.sessions.TraceInfo;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.util.Map;
import java.util.UUID;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class Session {
    private final UUID sessionId;
    private Map<String, Object> customMetadata;
    private final ThinCallSupport callSupport;

    public Session(ThinCallSupport callSupport) {
        this.callSupport = callSupport;
        this.sessionId = UUID.randomUUID();
    }

    public Session(UUID sessionId, ThinCallSupport callSupport) {
        this.sessionId = sessionId;
        this.callSupport = callSupport;
    }

    public Session customMetadata(Map<String, Object> customMetadata) {
        ParameterUtils.validateBasicMap(customMetadata);
        this.customMetadata = customMetadata;
        return this;
    }

    public String getSessionId() {
        return this.sessionId.toString();
    }

    public Map<String, Object> getCustomMetadata() {
        return this.customMetadata;
    }

    public SessionInfo getSessionInfo() {
        return new SessionInfo(this.sessionId.toString(), this.customMetadata);
    }

    public TraceInfo createTrace(String input) {
        return new TraceInfo(this.sessionId, UUID.randomUUID(), input, this.callSupport);
    }
}

