/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin.resources.sessions;

import ai.freeplay.client.thin.internal.ThinCallSupport;
import java.util.Objects;
import java.util.UUID;

public class TraceInfo {
    public UUID sessionId;
    public UUID traceId;
    public String input;
    public String output;
    private final ThinCallSupport callSupport;

    public TraceInfo(UUID sessionId, UUID traceId, String input, ThinCallSupport callSupport) {
        this.sessionId = sessionId;
        this.traceId = traceId;
        this.input = input;
        this.output = null;
        this.callSupport = callSupport;
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public UUID getTraceId() {
        return this.traceId;
    }

    public String getInput() {
        return this.input;
    }

    public String getOutput() {
        return this.output;
    }

    public void recordOutput(String projectId, String output) {
        this.output = output;
        this.callSupport.recordTrace(projectId, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TraceInfo that = (TraceInfo)o;
        return Objects.equals(this.traceId, that.traceId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.input, that.input) && Objects.equals(this.output, that.output);
    }
}

