/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client;

import ai.freeplay.client.ProviderConfig;
import ai.freeplay.client.exceptions.FreeplayConfigurationException;

public class ProviderConfigs {
    private final ProviderConfig.OpenAIProviderConfig openAIConfig;
    private final ProviderConfig.AnthropicProviderConfig anthropicConfig;

    public static ProviderConfigs fromGenericConfig(ProviderConfig providerConfig) {
        if (providerConfig instanceof ProviderConfig.OpenAIProviderConfig) {
            return new ProviderConfigs((ProviderConfig.OpenAIProviderConfig)providerConfig);
        }
        if (providerConfig instanceof ProviderConfig.AnthropicProviderConfig) {
            return new ProviderConfigs((ProviderConfig.AnthropicProviderConfig)providerConfig);
        }
        throw new FreeplayConfigurationException("Unknown provider config of type " + providerConfig.getClass().getName());
    }

    public ProviderConfigs(ProviderConfig.OpenAIProviderConfig openAIConfig, ProviderConfig.AnthropicProviderConfig anthropicConfig) {
        this.openAIConfig = openAIConfig;
        this.anthropicConfig = anthropicConfig;
    }

    public ProviderConfigs(ProviderConfig.OpenAIProviderConfig openAIConfig) {
        this(openAIConfig, null);
    }

    public ProviderConfigs(ProviderConfig.AnthropicProviderConfig anthropicConfig) {
        this(null, anthropicConfig);
    }

    public ProviderConfig.OpenAIProviderConfig getOpenAIConfig() {
        return this.openAIConfig;
    }

    public ProviderConfig.AnthropicProviderConfig getAnthropicConfig() {
        return this.anthropicConfig;
    }
}

