/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.flavor;

import ai.freeplay.client.HttpConfig;
import ai.freeplay.client.ProviderConfigs;
import ai.freeplay.client.exceptions.FreeplayClientException;
import ai.freeplay.client.exceptions.FreeplayException;
import ai.freeplay.client.exceptions.LLMServerException;
import ai.freeplay.client.flavor.ChatFlavor;
import ai.freeplay.client.internal.Http;
import ai.freeplay.client.internal.JSONUtil;
import ai.freeplay.client.internal.StringUtils;
import ai.freeplay.client.internal.TemplateUtils;
import ai.freeplay.client.model.ChatCompletionResponse;
import ai.freeplay.client.model.ChatMessage;
import ai.freeplay.client.model.CompletionResponse;
import ai.freeplay.client.model.IndexedChatMessage;
import ai.freeplay.client.model.Provider;
import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.net.http.HttpResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AnthropicChatFlavor
implements ChatFlavor {
    private static final String ANTHROPIC_MESSAGES_URL = "https://api.anthropic.com/v1/messages";
    private static final String ANTHROPIC_VERSION = "2023-06-01";
    private static final String ANTHROPIC_CONTENT_BLOCK_DELTA_EVENT_TYPE = "content_block_delta";
    private static final String ANTHROPIC_MESSAGE_DELTA_EVENT_TYPE = "message_delta";

    @Override
    public String getFormatType() {
        return "anthropic_chat";
    }

    @Override
    public Provider getProviderEnum() {
        return Provider.Anthropic;
    }

    @Override
    public Collection<ChatMessage> formatPrompt(String template, Map<String, Object> variables) {
        try {
            return JSON.std.listFrom((Object)template).stream().map(message -> {
                Map messageMap = (Map)message;
                String formatted = TemplateUtils.format(String.valueOf(messageMap.get("content")), variables);
                return new ChatMessage(String.valueOf(messageMap.get("role")), formatted);
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new FreeplayClientException("Error formatting chat prompt template.", e);
        }
    }

    @Override
    public CompletionResponse callService(Collection<ChatMessage> formattedMessages, ProviderConfigs providerConfig, Map<String, Object> mergedLLMParameters, HttpConfig httpConfig) throws FreeplayException {
        ChatCompletionResponse chatResponse = this.callChatService(formattedMessages, providerConfig, mergedLLMParameters, httpConfig);
        return new CompletionResponse(chatResponse.getContent(), chatResponse.isComplete(), true);
    }

    @Override
    public Stream<IndexedChatMessage> callServiceStream(Collection<ChatMessage> formattedMessages, ProviderConfigs providerConfig, Map<String, Object> mergedLLMParameters, HttpConfig httpConfig) {
        HttpResponse<Stream<String>> httpResponse;
        AnthropicChatFlavor.validateParameters(mergedLLMParameters);
        Map<String, Object> bodyMap = this.getRequestBody(formattedMessages, mergedLLMParameters);
        bodyMap.put("stream", true);
        try {
            httpResponse = Http.postJson(ANTHROPIC_MESSAGES_URL, bodyMap, HttpResponse.BodyHandlers.ofLines(), httpConfig, "accept", "application/json", "anthropic-version", ANTHROPIC_VERSION, "x-api-key", providerConfig.getAnthropicConfig().getApiKey());
        }
        catch (Exception e) {
            throw new FreeplayException("Error calling Anthropic.", e);
        }
        AtomicReference<StreamState> streamStateRef = new AtomicReference<StreamState>(new StreamState());
        return httpResponse.body().map(line -> this.handleLine((String)line, (StreamState)streamStateRef.get())).filter(Objects::nonNull).map(completionResponse -> new IndexedChatMessage("assistant", completionResponse.getContent(), 0, completionResponse.isComplete(), completionResponse.isLast()));
    }

    @Override
    public ChatCompletionResponse callChatService(Collection<ChatMessage> messages, ProviderConfigs providerConfig, Map<String, Object> llmParameters, HttpConfig httpConfig) throws FreeplayException {
        Map<String, Object> responseBody;
        HttpResponse<String> response;
        AnthropicChatFlavor.validateParameters(llmParameters);
        Map<String, Object> bodyMap = this.getRequestBody(messages, llmParameters);
        try {
            response = Http.postJson(ANTHROPIC_MESSAGES_URL, bodyMap, httpConfig, "accept", "application/json", "anthropic-version", ANTHROPIC_VERSION, "x-api-key", providerConfig.getAnthropicConfig().getApiKey());
        }
        catch (Exception e) {
            throw new FreeplayException("Error calling Anthropic.", e);
        }
        Http.throwFreeplayIfError(response, 200);
        try {
            responseBody = Http.parseBody(response);
        }
        catch (FreeplayException e) {
            throw new LLMServerException("Error calling Anthropic.", e);
        }
        Http.throwLLMIfError(response, 200);
        List responseContents = (List)responseBody.get("content");
        AtomicInteger index = new AtomicInteger(0);
        List<IndexedChatMessage> anthropicMessages = responseContents.stream().map(messageObject -> new IndexedChatMessage(String.valueOf(responseBody.get("role")), String.valueOf(messageObject.get("text")), index.getAndIncrement(), "stop_sequence".equals(messageObject.get("stop_reason")), true)).collect(Collectors.toList());
        return new ChatCompletionResponse(anthropicMessages);
    }

    @Override
    public String serializeForRecord(Collection<ChatMessage> formattedMessages) {
        return JSONUtil.asString(formattedMessages);
    }

    @Override
    public String getContentFromChunk(IndexedChatMessage chunk) {
        return chunk.getContent();
    }

    @Override
    public boolean isLastChunk(IndexedChatMessage chunk) {
        return chunk.isLast();
    }

    @Override
    public boolean isComplete(IndexedChatMessage chunk) {
        return chunk.isComplete();
    }

    private Map<String, Object> getRequestBody(Collection<ChatMessage> messages, Map<String, Object> llmParameters) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>(llmParameters);
        Collection messagesWithoutSystem = messages.stream().filter(msg -> !msg.getRole().equals("system")).collect(Collectors.toList());
        bodyMap.put("messages", messagesWithoutSystem);
        Optional<String> maybeSystemContent = messages.stream().filter(msg -> msg.getRole().equals("system")).findFirst().map(ChatMessage::getContent);
        maybeSystemContent.ifPresent(systemContent -> bodyMap.put("system", systemContent));
        return bodyMap;
    }

    private static void validateParameters(Map<String, Object> llmParameters) {
        if (!llmParameters.containsKey("model")) {
            throw new FreeplayException("The 'model' parameter is required when calling Anthropic.");
        }
        if (!llmParameters.containsKey("max_tokens")) {
            throw new FreeplayException("The 'max_tokens' parameter is required when calling Anthropic.");
        }
        if (llmParameters.containsKey("prompt")) {
            throw new FreeplayException("The 'prompt' parameter cannot be specified. It is populated automatically.");
        }
    }

    private CompletionResponse handleLine(String line, StreamState streamState) {
        String fieldValue;
        if (StringUtils.isBlank(line)) {
            return AnthropicChatFlavor.finishEvent(streamState);
        }
        String[] fields = line.split(":", 2);
        if (fields.length == 2) {
            String fieldName = fields[0].trim();
            fieldValue = fields[1].stripLeading();
            if ("data".equals(fieldName)) {
                if (StringUtils.isBlank(fieldValue.trim())) {
                    return null;
                }
                Map<String, Object> objectMap = JSONUtil.parseMap(fieldValue);
                String eventType = (String)objectMap.get("type");
                if (eventType.equals(ANTHROPIC_CONTENT_BLOCK_DELTA_EVENT_TYPE)) {
                    Map delta = (Map)objectMap.get("delta");
                    streamState.appendData((String)delta.get("text"));
                } else if (eventType.equals(ANTHROPIC_MESSAGE_DELTA_EVENT_TYPE)) {
                    Map delta = (Map)objectMap.get("delta");
                    streamState.setStopReason((String)delta.get("stop_reason"));
                }
                return null;
            }
            if (!"event".equals(fieldName)) {
                throw new FreeplayException("Got unknown field in the stream: '" + fieldName + "'");
            }
        } else {
            throw new FreeplayException("Got unknown line in the stream: '" + line + "'");
        }
        streamState.startEvent(fieldValue);
        return null;
    }

    private static CompletionResponse finishEvent(StreamState streamState) {
        if (ANTHROPIC_CONTENT_BLOCK_DELTA_EVENT_TYPE.equals(streamState.eventName) || ANTHROPIC_MESSAGE_DELTA_EVENT_TYPE.equals(streamState.eventName)) {
            return streamState.closeCurrentEvent();
        }
        streamState.reset();
        return null;
    }

    private static class StreamState {
        private final Object lock = new Object();
        private String eventName;
        private StringBuilder data;
        private String stopReason;
        private boolean isComplete;

        private StreamState() {
            this.reset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startEvent(String name) {
            Object object = this.lock;
            synchronized (object) {
                if (this.eventName != null) {
                    throw new FreeplayException(String.format("Attempting to start a new event (%s) when the previous has not been closed.%n", name));
                }
                this.eventName = name;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void appendData(String newData) {
            if (newData != null) {
                Object object = this.lock;
                synchronized (object) {
                    this.data.append(newData);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CompletionResponse closeCurrentEvent() {
            Object object = this.lock;
            synchronized (object) {
                boolean isLast = this.stopReason != null;
                CompletionResponse response = new CompletionResponse(this.data.toString(), this.isComplete, isLast);
                this.reset();
                return response;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() {
            Object object = this.lock;
            synchronized (object) {
                this.eventName = null;
                this.data = new StringBuilder();
                this.stopReason = null;
                this.isComplete = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStopReason(String stopReason) {
            Object object = this.lock;
            synchronized (object) {
                this.stopReason = stopReason;
                if (StringUtils.isNotBlank(stopReason) && "stop_sequence".equals(stopReason)) {
                    this.isComplete = true;
                }
            }
        }
    }
}

