/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.internal;

import ai.freeplay.client.Freeplay;
import ai.freeplay.client.HttpConfig;
import ai.freeplay.client.ProviderConfigs;
import ai.freeplay.client.RecordProcessor;
import ai.freeplay.client.exceptions.FreeplayConfigurationException;
import ai.freeplay.client.exceptions.FreeplayException;
import ai.freeplay.client.exceptions.FreeplayServerException;
import ai.freeplay.client.flavor.ChatFlavor;
import ai.freeplay.client.flavor.Flavors;
import ai.freeplay.client.internal.CallInfo;
import ai.freeplay.client.internal.Http;
import ai.freeplay.client.internal.JSONUtil;
import ai.freeplay.client.internal.ParameterUtils;
import ai.freeplay.client.internal.PromptInfo;
import ai.freeplay.client.internal.PromptUtils;
import ai.freeplay.client.model.ChatCompletionResponse;
import ai.freeplay.client.model.ChatMessage;
import ai.freeplay.client.model.CompletionResponse;
import ai.freeplay.client.model.IndexedChatMessage;
import ai.freeplay.client.model.PromptTemplate;
import ai.freeplay.client.model.TestRun;
import ai.freeplay.client.processor.ChatPromptProcessor;
import ai.freeplay.client.processor.LLMCallInfo;
import ai.freeplay.client.processor.TemplateResolver;
import java.net.http.HttpResponse;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

public class CallSupport {
    public static final System.Logger LOGGER = System.getLogger(Freeplay.class.getName());
    private final String freeplayApiKey;
    private final String baseUrl;
    private final ChatFlavor clientFlavor;
    private final Map<String, Object> clientLLMParameters;
    private final ProviderConfigs providerConfig;
    private final HttpConfig httpConfig;
    private final RecordProcessor recordProcessor;
    private final TemplateResolver templateResolver;

    public CallSupport(String freeplayApiKey, String baseUrl, ProviderConfigs providerConfig, ChatFlavor flavor, Map<String, Object> llmParameters, HttpConfig httpConfig, RecordProcessor recordProcessor, TemplateResolver templateResolver) {
        this.freeplayApiKey = freeplayApiKey;
        this.baseUrl = baseUrl;
        this.providerConfig = providerConfig;
        this.clientFlavor = flavor;
        this.clientLLMParameters = llmParameters != null ? llmParameters : Collections.emptyMap();
        this.httpConfig = httpConfig;
        this.recordProcessor = recordProcessor != null ? recordProcessor : new DefaultRecordProcessor();
        this.templateResolver = templateResolver;
    }

    public static String createSessionId() throws FreeplayException {
        return UUID.randomUUID().toString();
    }

    public Collection<PromptTemplate> getPrompts(String projectId, String tag) throws FreeplayException {
        String finalEnvironment = PromptUtils.getFinalEnvironment(tag);
        return this.templateResolver.getPrompts(projectId, finalEnvironment);
    }

    public Optional<PromptTemplate> findPrompt(Collection<PromptTemplate> templates, String templateName) {
        return templates.stream().filter(template -> template.getName().equals(templateName)).findFirst();
    }

    public TestRun createTestRun(String projectId, String environment, String testListName) {
        Map<String, Object> objectMap;
        HttpResponse<String> response;
        String url = this.getUrl("v2/projects/%s/test-runs", projectId);
        try {
            response = Http.postJsonWithBearer(url, Map.of("playlist_name", testListName), this.freeplayApiKey, this.httpConfig);
        }
        catch (FreeplayException e) {
            throw new FreeplayServerException("Error creating test run.", e);
        }
        Http.throwFreeplayIfError(response, 201);
        try {
            objectMap = Http.parseBody(response);
        }
        catch (FreeplayException e) {
            throw new FreeplayServerException("Error creating test run.", e);
        }
        String testRunId = String.valueOf(objectMap.get("test_run_id"));
        List inputs = (List)objectMap.get("inputs");
        return new TestRun(this, projectId, environment, testRunId, inputs);
    }

    public CompletionResponse prepareAndMakeCall(String sessionId, Collection<PromptTemplate> templates, String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, Map<String, Object> customMetadata, String tag, String testRunId, ChatFlavor flavor, ChatPromptProcessor promptProcessor) throws FreeplayException {
        Optional<PromptTemplate> maybePrompt = this.findPrompt(templates, templateName);
        if (maybePrompt.isEmpty()) {
            throw new FreeplayConfigurationException("Prompt template " + templateName + " in environment " + tag + " not found.");
        }
        PromptTemplate template = maybePrompt.get();
        Map<String, Object> mergedLLMParameters = this.getMergedParameters(template, llmParameters);
        ChatFlavor activeFlavor = this.getActiveFlavor(flavor, template);
        Collection formattedPrompt = activeFlavor.formatPrompt(template.getContent(), variables);
        Collection modifiedPrompt = promptProcessor != null ? (Collection)promptProcessor.apply(formattedPrompt, new LLMCallInfo(activeFlavor.getProviderEnum(), mergedLLMParameters)) : formattedPrompt;
        Instant start = Instant.ofEpochMilli(System.currentTimeMillis());
        CompletionResponse response = activeFlavor.callService(modifiedPrompt, this.providerConfig, mergedLLMParameters, this.httpConfig);
        Instant end = Instant.ofEpochMilli(System.currentTimeMillis());
        Optional<String> completionId = this.recordProcessor.record(new PromptInfo(template.getPromptTemplateVersionId(), template.getPromptTemplateId(), activeFlavor.getFormatType(), activeFlavor.getProvider(), String.valueOf(mergedLLMParameters.get("model")), mergedLLMParameters), new CallInfo(sessionId, testRunId, start, end, tag, variables, customMetadata, activeFlavor.serializeForRecord(modifiedPrompt), response.getContent(), response.isComplete()));
        completionId.ifPresent(response::setCompletionId);
        return response;
    }

    public Stream<IndexedChatMessage> makeCallStream(String sessionId, PromptTemplate template, Map<String, Object> variables, Map<String, Object> llmParameters, Map<String, Object> customMetadata, String tag, String testRunId, ChatFlavor callFlavor, ChatPromptProcessor promptProcessor) throws FreeplayException {
        Map<String, Object> mergedLLMParameters = this.getMergedParameters(template, llmParameters);
        ChatFlavor activeFlavor = this.getActiveFlavor(callFlavor, template);
        Collection formattedPrompt = activeFlavor.formatPrompt(template.getContent(), variables);
        Collection modifiedPrompt = promptProcessor != null ? (Collection)promptProcessor.apply(formattedPrompt, new LLMCallInfo(activeFlavor.getProviderEnum(), mergedLLMParameters)) : formattedPrompt;
        Instant start = Instant.ofEpochMilli(System.currentTimeMillis());
        Stream<IndexedChatMessage> responseStream = activeFlavor.callServiceStream(modifiedPrompt, this.providerConfig, mergedLLMParameters, this.httpConfig);
        return this.handleStream(sessionId, template, variables, tag, testRunId, mergedLLMParameters, customMetadata, activeFlavor, modifiedPrompt, start, responseStream);
    }

    public ChatCompletionResponse makeContinueChatCall(String sessionId, Collection<PromptTemplate> templates, String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, Map<String, Object> customMetadata, String tag, String testRunId, ChatFlavor flavor, ChatPromptProcessor promptProcessor) throws FreeplayException {
        Optional<PromptTemplate> maybePrompt = this.findPrompt(templates, templateName);
        return maybePrompt.map(prompt -> {
            ChatFlavor activeFlavor = this.getActiveFlavor(flavor, (PromptTemplate)prompt);
            Collection<ChatMessage> formattedPrompt = activeFlavor.formatPrompt(prompt.getContent(), variables);
            return this.makeContinueChatCall(sessionId, (PromptTemplate)prompt, formattedPrompt, variables, llmParameters, customMetadata, tag, testRunId, promptProcessor);
        }).orElseThrow(() -> new FreeplayConfigurationException(String.format("Prompt template %s not found in environment %s.", templateName, tag)));
    }

    public ChatCompletionResponse makeContinueChatCall(String sessionId, PromptTemplate template, Collection<ChatMessage> formattedMessages, Map<String, Object> variables, Map<String, Object> llmParameters, Map<String, Object> customMetadata, String tag, String testRunId, ChatPromptProcessor promptProcessor) throws FreeplayException {
        Map<String, Object> mergedLLMParameters = this.getMergedParameters(template, llmParameters);
        ChatFlavor activeFlavor = this.getActiveFlavor(this.clientFlavor, template);
        Collection finalMessages = promptProcessor != null ? (Collection)promptProcessor.apply(formattedMessages, new LLMCallInfo(activeFlavor.getProviderEnum(), mergedLLMParameters)) : formattedMessages;
        Instant start = Instant.ofEpochMilli(System.currentTimeMillis());
        ChatCompletionResponse response = activeFlavor.callChatService(finalMessages, this.providerConfig, mergedLLMParameters, this.httpConfig);
        Instant end = Instant.ofEpochMilli(System.currentTimeMillis());
        Optional<String> completionId = this.recordProcessor.record(new PromptInfo(template.getPromptTemplateVersionId(), template.getPromptTemplateId(), activeFlavor.getFormatType(), activeFlavor.getProvider(), String.valueOf(mergedLLMParameters.get("model")), mergedLLMParameters), new CallInfo(sessionId, testRunId, start, end, tag, variables, customMetadata, activeFlavor.serializeForRecord(finalMessages), response.getContent(), response.isComplete()));
        completionId.ifPresent(response::setCompletionId);
        return response;
    }

    public Stream<IndexedChatMessage> makeContinueChatCallStream(String sessionId, PromptTemplate template, Collection<ChatMessage> formattedMessages, Map<String, Object> variables, Map<String, Object> llmParameters, Map<String, Object> customMetadata, String tag, String testRunId) throws FreeplayException {
        Map<String, Object> mergedLLMParameters = this.getMergedParameters(template, llmParameters);
        ChatFlavor activeFlavor = this.getActiveFlavor(this.clientFlavor, template);
        Instant start = Instant.ofEpochMilli(System.currentTimeMillis());
        Stream<IndexedChatMessage> responseStream = activeFlavor.callServiceStream(formattedMessages, this.providerConfig, mergedLLMParameters, this.httpConfig);
        return this.handleStream(sessionId, template, variables, tag, testRunId, mergedLLMParameters, customMetadata, activeFlavor, formattedMessages, start, responseStream);
    }

    private Stream<IndexedChatMessage> handleStream(String sessionId, PromptTemplate template, Map<String, Object> variables, String tag, String testRunId, Map<String, Object> mergedLLMParameters, Map<String, Object> customMetadata, ChatFlavor activeFlavor, Collection<ChatMessage> formattedPrompt, Instant start, Stream<IndexedChatMessage> responseStream) {
        AtomicReference<String> aggregatedContent = new AtomicReference<String>("");
        return responseStream.map(chunk -> {
            aggregatedContent.getAndUpdate(previous -> previous + activeFlavor.getContentFromChunk((IndexedChatMessage)chunk));
            if (activeFlavor.isLastChunk((IndexedChatMessage)chunk)) {
                Instant end = Instant.ofEpochMilli(System.currentTimeMillis());
                Optional<String> completionId = this.recordProcessor.record(new PromptInfo(template.getPromptTemplateVersionId(), template.getPromptTemplateId(), activeFlavor.getFormatType(), activeFlavor.getProvider(), String.valueOf(mergedLLMParameters.get("model")), mergedLLMParameters), new CallInfo(sessionId, testRunId, start, end, tag, variables, customMetadata, activeFlavor.serializeForRecord(formattedPrompt), (String)aggregatedContent.get(), activeFlavor.isComplete((IndexedChatMessage)chunk)));
                completionId.ifPresent(chunk::setCompletionId);
            }
            return chunk;
        });
    }

    public ChatFlavor getActiveFlavor(ChatFlavor callFlavor, PromptTemplate prompt) {
        if (callFlavor != null) {
            return callFlavor;
        }
        if (this.clientFlavor != null) {
            return this.clientFlavor;
        }
        String flavorName = prompt.getFlavorName();
        return Flavors.getFlavorByName(flavorName);
    }

    private Map<String, Object> getMergedParameters(PromptTemplate promptTemplate, Map<String, Object> callLLMParameters) {
        HashMap<String, Object> merged = new HashMap<String, Object>(16);
        merged.putAll(promptTemplate.getLLMParameters());
        merged.putAll(this.clientLLMParameters);
        merged.putAll(callLLMParameters);
        return merged;
    }

    private String getUrl(String path, Object ... args) {
        return String.format("%s/%s", this.baseUrl, String.format(path, args));
    }

    public void recordCompletionFeedback(String completionId, Map<String, Object> feedback) throws FreeplayException {
        ParameterUtils.validateBasicMap(feedback);
        String url = this.getUrl("v1/completion_feedback/%s", completionId);
        try {
            Http.jsonRequest(url, JSONUtil.asString(feedback), HttpResponse.BodyHandlers.ofString(), this.httpConfig, "PUT", Http.authHeaders(this.freeplayApiKey));
        }
        catch (FreeplayException e) {
            throw new FreeplayServerException("Error creating session.", e);
        }
    }

    private class DefaultRecordProcessor
    implements RecordProcessor {
        private DefaultRecordProcessor() {
        }

        @Override
        public Optional<String> record(PromptInfo promptInfo, CallInfo callInfo) {
            String url = CallSupport.this.getUrl("v1/record", new Object[0]);
            HashMap<String, Object> payload = new HashMap<String, Object>(32);
            payload.put("session_id", callInfo.getSessionId());
            payload.put("project_version_id", promptInfo.getPromptTemplateVersionId());
            payload.put("prompt_template_id", promptInfo.getPromptTemplateId());
            payload.put("start_time", callInfo.getStartTime());
            payload.put("end_time", callInfo.getEndTime());
            payload.put("tag", callInfo.getTag());
            payload.put("inputs", callInfo.getInputs());
            payload.put("custom_metadata", callInfo.getCustomMetadata());
            payload.put("prompt_content", callInfo.getPromptContent());
            payload.put("return_content", callInfo.getReturnContent());
            payload.put("format_type", promptInfo.getFormatType());
            payload.put("is_complete", callInfo.isComplete());
            payload.put("test_run_id", callInfo.getTestRunId());
            payload.put("provider", promptInfo.getProvider());
            payload.put("model", promptInfo.getModel());
            payload.put("llm_parameters", promptInfo.getLLMParameters());
            try {
                HttpResponse<String> response = Http.postJsonWithBearer(url, payload, CallSupport.this.freeplayApiKey);
                Map<String, Object> objectMap = Http.parseBody(response);
                String completionId = String.valueOf(objectMap.get("completion_id"));
                return Optional.of(completionId);
            }
            catch (Exception e) {
                LOGGER.log(System.Logger.Level.WARNING, "Unable to record LLM call. Cause: {0}", e.getMessage());
                return Optional.empty();
            }
        }
    }
}

